/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.constant;

import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public enum SpecialGoodsTaxNoEnum {
    INTANGIBLE_ASSETS_OLD("4060000000000000000"),
    INTANGIBLE_ASSETS_NEW("4069900000000000000");

    private String value;

    public String getValue() {
        return this.value;
    }

    private SpecialGoodsTaxNoEnum(String value) {
        this.value = value;
    }

    public static boolean isIntangibleAssets(String value) {
        return Arrays.asList(SpecialGoodsTaxNoEnum.INTANGIBLE_ASSETS_OLD.value, SpecialGoodsTaxNoEnum.INTANGIBLE_ASSETS_NEW.value).contains(value);
    }

    public static SpecialGoodsTaxNoEnum getDefaultOrByValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        for (SpecialGoodsTaxNoEnum returnMode : SpecialGoodsTaxNoEnum.values()) {
            if (!returnMode.value.equals(value)) continue;
            return returnMode;
        }
        throw new SplitRuleParamException(String.format("returnMode = [%s] is invalid", value));
    }
}

