/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.constant;

import java.util.Optional;

public enum TaxDeviceType {
    BW_SINGL("1", "BW", "\u767e\u671b\u5355\u76d8"),
    BW_SERVER("2", "BW", "\u767e\u671b\u670d\u52a1\u5668"),
    HX_SINGL("3", "HX", "\u822a\u4fe1\u5355\u76d8"),
    HX_SERVER("4", "HX", "\u822a\u4fe1\u670d\u52a1\u5668"),
    V_UKEY("5", "BW", "\u865a\u62dfUKey\u8bbe\u5907"),
    UKEY("8", "BW", "\u7a0e\u52a1UKey\u8bbe\u5907"),
    TAX_CER("7", "HX", "\u7a0e\u52a1\u8bc1\u4e66");

    private String type;
    private String code;
    private String typeDesc;

    private TaxDeviceType(String type, String code, String typeDesc) {
        this.type = type;
        this.typeDesc = typeDesc;
        this.code = code;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeDesc() {
        return this.typeDesc;
    }

    public void setTypeDesc(String typeDesc) {
        this.typeDesc = typeDesc;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public static Optional<TaxDeviceType> getDeviceTypeByType(String type) {
        TaxDeviceType[] taxDeviceTypes;
        for (TaxDeviceType tmp : taxDeviceTypes = TaxDeviceType.values()) {
            if (!tmp.getType().equals(type)) continue;
            return Optional.of(tmp);
        }
        return Optional.of(HX_SINGL);
    }

    public static boolean isBW(TaxDeviceType taxDeviceType) {
        return taxDeviceType == BW_SERVER || taxDeviceType == BW_SINGL || taxDeviceType == UKEY || taxDeviceType == V_UKEY;
    }
}

