/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.domain;

import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import com.xforceplus.phoenix.split.pojo.OrderItemPojo;
import com.xforceplus.phoenix.split.pojo.OrderPojo;
import com.xforceplus.phoenix.split.pojo.SplitOrderRulePojo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;

public class OrderSplitDomain {
    private static final BigDecimal MAX_ERROR_AMOUNT = new BigDecimal("0.01");
    private OrderPojo order;
    private List<OrderItemPojo> orderItems;
    private SplitOrderRulePojo splitOrderRulePojo;
    private OrderItemPojo lastOrderItem;
    private BigDecimal rate;

    public OrderSplitDomain(OrderPojo order, SplitOrderRulePojo splitOrderRulePojo) {
        this.rate = splitOrderRulePojo.getSplitAmount().divide(order.getAmountWithTax(), 11, 1);
        if (this.rate.compareTo(BigDecimal.ONE) >= 0) {
            throw new SplitRuleParamException("\u62c6\u5206\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u8ba2\u5355\u542b\u7a0e\u603b\u91d1\u989d!");
        }
        this.order = order;
        this.splitOrderRulePojo = splitOrderRulePojo;
        this.orderItems = new ArrayList<OrderItemPojo>();
        for (int i = 0; i < order.getOrderItems().size() - 1; ++i) {
            this.orderItems.add(order.getOrderItems().get(i));
        }
        this.lastOrderItem = order.getOrderItems().get(order.getOrderItems().size() - 1);
    }

    public List<OrderPojo> splitOrder() {
        ArrayList<OrderItemPojo> firstItems = new ArrayList<OrderItemPojo>();
        ArrayList<OrderItemPojo> secondItems = new ArrayList<OrderItemPojo>();
        BigDecimal totalSplitAmount = BigDecimal.ZERO;
        for (OrderItemPojo orderItemPojo : this.orderItems) {
            OrderItemPojo splitOrderItem = this.splitItem(orderItemPojo);
            firstItems.add(splitOrderItem);
            secondItems.add(orderItemPojo);
            totalSplitAmount = totalSplitAmount.add(splitOrderItem.getAmountWithTax());
        }
        BigDecimal surplusSplitAmount = this.splitOrderRulePojo.getSplitAmount().subtract(totalSplitAmount);
        firstItems.add(this.splitLastItem(surplusSplitAmount));
        secondItems.add(this.lastOrderItem);
        ArrayList<OrderPojo> result = new ArrayList<OrderPojo>(2);
        result.add(this.createOrder(firstItems));
        result.add(this.createOrder(secondItems));
        return result;
    }

    private OrderPojo createOrder(List<OrderItemPojo> orderItems) {
        OrderPojo orderPojo = new OrderPojo();
        orderPojo.setOrderItems(orderItems);
        orderPojo.setExtInfo(this.order.getExtInfo());
        BigDecimal amountWithTax = BigDecimal.ZERO;
        BigDecimal amountWithoutTax = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (OrderItemPojo orderItemPojo : orderItems) {
            amountWithTax = amountWithTax.add(orderItemPojo.getAmountWithTax());
            amountWithoutTax = amountWithoutTax.add(orderItemPojo.getAmountWithoutTax());
            taxAmount = taxAmount.add(orderItemPojo.getTaxAmount());
        }
        orderPojo.setAmountWithoutTax(amountWithoutTax);
        orderPojo.setAmountWithTax(amountWithTax);
        orderPojo.setTaxAmount(taxAmount);
        return orderPojo;
    }

    private OrderItemPojo splitLastItem(BigDecimal surplusSplitAmount) {
        OrderItemPojo newOrderItem = new OrderItemPojo();
        Amount amount = this.calculationAmountByWithTaxAmount(this.lastOrderItem, surplusSplitAmount);
        newOrderItem.setAmountWithoutTax(amount.getWithoutTaxAmount());
        newOrderItem.setTaxAmount(amount.getTaxAmount());
        newOrderItem.setAmountWithTax(amount.getWithTaxAmount());
        this.splitInnerDiscountAmount(this.lastOrderItem, newOrderItem);
        this.splitOutterDiscountAmount(this.lastOrderItem, newOrderItem);
        this.subtractSplitAmount(newOrderItem, this.lastOrderItem);
        this.processQuantityAndUnitPrice(newOrderItem, this.lastOrderItem);
        newOrderItem.setTaxRate(this.lastOrderItem.getTaxRate());
        newOrderItem.setExtInfo(this.lastOrderItem.getExtInfo());
        return newOrderItem;
    }

    private Amount calculationAmountByWithTaxAmount(OrderItemPojo lastOrderItem, BigDecimal surplusSplitAmount) {
        BigDecimal splitAmountWithoutTax = surplusSplitAmount.divide(BigDecimal.ONE.add(lastOrderItem.getTaxRate()), 2, RoundingMode.HALF_UP);
        BigDecimal splitTaxAmount = surplusSplitAmount.subtract(splitAmountWithoutTax);
        return new Amount(surplusSplitAmount, splitAmountWithoutTax, splitTaxAmount);
    }

    private OrderItemPojo splitItem(OrderItemPojo orderItemPojo) {
        OrderItemPojo newOrderItem = new OrderItemPojo();
        Amount amount = this.calculationAmountByRate(orderItemPojo.getAmountWithoutTax(), orderItemPojo.getTaxRate());
        newOrderItem.setAmountWithoutTax(amount.getWithoutTaxAmount());
        newOrderItem.setTaxAmount(amount.getTaxAmount());
        newOrderItem.setAmountWithTax(amount.getWithTaxAmount());
        this.splitInnerDiscountAmount(orderItemPojo, newOrderItem);
        this.splitOutterDiscountAmount(orderItemPojo, newOrderItem);
        this.subtractSplitAmount(newOrderItem, orderItemPojo);
        this.processQuantityAndUnitPrice(newOrderItem, orderItemPojo);
        newOrderItem.setTaxRate(orderItemPojo.getTaxRate());
        newOrderItem.setExtInfo(orderItemPojo.getExtInfo());
        return newOrderItem;
    }

    private void splitOutterDiscountAmount(OrderItemPojo orderItemPojo, OrderItemPojo newOrderItem) {
        Amount amount = this.calculationAmountByRate(orderItemPojo.getOutterDiscountWithoutTax(), orderItemPojo.getTaxRate());
        newOrderItem.setOutterDiscountWithoutTax(amount.getWithoutTaxAmount());
        newOrderItem.setOutterDiscountTax(amount.getTaxAmount());
        newOrderItem.setOutterDiscountWithTax(amount.getWithTaxAmount());
    }

    private void splitInnerDiscountAmount(OrderItemPojo orderItemPojo, OrderItemPojo newOrderItem) {
        Amount amount = this.calculationAmountByRate(orderItemPojo.getInnerDiscountWithoutTax(), orderItemPojo.getTaxRate());
        newOrderItem.setInnerDiscountWithoutTax(amount.getWithoutTaxAmount());
        newOrderItem.setInnerDiscountTax(amount.getTaxAmount());
        newOrderItem.setInnerDiscountWithTax(amount.getWithTaxAmount());
    }

    private void subtractSplitAmount(OrderItemPojo newOrderItem, OrderItemPojo orderItemPojo) {
        orderItemPojo.setAmountWithoutTax(orderItemPojo.getAmountWithoutTax().subtract(newOrderItem.getAmountWithoutTax()));
        orderItemPojo.setAmountWithTax(orderItemPojo.getAmountWithTax().subtract(newOrderItem.getAmountWithTax()));
        orderItemPojo.setTaxAmount(orderItemPojo.getTaxAmount().subtract(newOrderItem.getTaxAmount()));
        orderItemPojo.setOutterDiscountWithoutTax(orderItemPojo.getOutterDiscountWithoutTax().subtract(newOrderItem.getOutterDiscountWithoutTax()));
        orderItemPojo.setOutterDiscountWithTax(orderItemPojo.getOutterDiscountWithTax().subtract(newOrderItem.getOutterDiscountWithTax()));
        orderItemPojo.setOutterDiscountTax(orderItemPojo.getOutterDiscountTax().subtract(newOrderItem.getOutterDiscountTax()));
        orderItemPojo.setInnerDiscountWithoutTax(orderItemPojo.getInnerDiscountWithoutTax().subtract(newOrderItem.getInnerDiscountWithoutTax()));
        orderItemPojo.setInnerDiscountWithTax(orderItemPojo.getInnerDiscountWithTax().subtract(newOrderItem.getInnerDiscountWithTax()));
        orderItemPojo.setInnerDiscountTax(orderItemPojo.getInnerDiscountTax().subtract(newOrderItem.getInnerDiscountTax()));
    }

    private void processQuantityAndUnitPrice(OrderItemPojo newOrderItem, OrderItemPojo orderItemPojo) {
        BigDecimal quantity = orderItemPojo.getQuantity();
        BigDecimal unitPrice = orderItemPojo.getUnitPrice();
        if (this.splitQuantity()) {
            if (this.nonZero(orderItemPojo.getUnitPrice())) {
                quantity = newOrderItem.getAmountWithoutTax().divide(orderItemPojo.getUnitPrice(), this.splitOrderRulePojo.getQuantityScale(), 1);
                orderItemPojo.setQuantity(orderItemPojo.getAmountWithoutTax().divide(orderItemPojo.getUnitPrice(), this.splitOrderRulePojo.getQuantityScale(), 1));
                this.checkQuantityAndUnitPrice(quantity, unitPrice, newOrderItem.getAmountWithoutTax());
                this.checkQuantityAndUnitPrice(orderItemPojo.getQuantity(), orderItemPojo.getUnitPrice(), orderItemPojo.getAmountWithoutTax());
            }
        } else if (this.splitUnitPrice()) {
            if (this.nonZero(orderItemPojo.getQuantity())) {
                unitPrice = newOrderItem.getAmountWithoutTax().divide(orderItemPojo.getQuantity(), this.splitOrderRulePojo.getUnitPriceScale(), 1);
                orderItemPojo.setUnitPrice(orderItemPojo.getAmountWithoutTax().divide(orderItemPojo.getQuantity(), this.splitOrderRulePojo.getUnitPriceScale(), 1));
                this.checkQuantityAndUnitPrice(quantity, unitPrice, newOrderItem.getAmountWithoutTax());
                this.checkQuantityAndUnitPrice(orderItemPojo.getQuantity(), orderItemPojo.getUnitPrice(), orderItemPojo.getAmountWithoutTax());
            }
        } else {
            throw new SplitRuleParamException("amountSplitRule\u503c\u4e0d\u5408\u6cd5, \u5408\u6cd5\u503c[1,2]");
        }
        newOrderItem.setQuantity(quantity);
        newOrderItem.setUnitPrice(unitPrice);
    }

    private void checkQuantityAndUnitPrice(BigDecimal quantity, BigDecimal unitPrice, BigDecimal amountWithoutTax) {
        if (quantity.multiply(unitPrice).setScale(2, 4).subtract(amountWithoutTax).abs().compareTo(MAX_ERROR_AMOUNT) > 0) {
            throw new SplitRuleParamException("\u65e0\u6cd5\u62c6\u5206\u8ba2\u5355\uff0c\u62c6\u5206\u540e\u5355\u4ef7*\u6570\u91cf\u4e0e\u4e0d\u542b\u7a0e\u91d1\u989d\u76f8\u5dee\u8d85\u8fc7\u4e00\u5206");
        }
    }

    private boolean nonZero(BigDecimal bigDecimal) {
        return bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) != 0;
    }

    private boolean splitUnitPrice() {
        return "1".equals(this.splitOrderRulePojo.getAmountSplitRule());
    }

    private boolean splitQuantity() {
        return "2".equals(this.splitOrderRulePojo.getAmountSplitRule());
    }

    private Amount calculationAmountByRate(BigDecimal amountWithoutTax, BigDecimal taxRate) {
        BigDecimal splitAmountWithoutTax = amountWithoutTax.multiply(this.rate).setScale(2, RoundingMode.HALF_UP);
        BigDecimal splitTaxAmount = splitAmountWithoutTax.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
        BigDecimal splitAmountWithTax = splitAmountWithoutTax.add(splitTaxAmount);
        return new Amount(splitAmountWithTax, splitAmountWithoutTax, splitTaxAmount);
    }

    private class Amount {
        private BigDecimal withTaxAmount;
        private BigDecimal withoutTaxAmount;
        private BigDecimal taxAmount;

        Amount(BigDecimal withTaxAmount, BigDecimal withoutTaxAmount, BigDecimal taxAmount) {
            this.withTaxAmount = withTaxAmount;
            this.withoutTaxAmount = withoutTaxAmount;
            this.taxAmount = taxAmount;
        }

        BigDecimal getWithTaxAmount() {
            return this.withTaxAmount;
        }

        BigDecimal getWithoutTaxAmount() {
            return this.withoutTaxAmount;
        }

        BigDecimal getTaxAmount() {
            return this.taxAmount;
        }
    }
}

