/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.domain;

import com.google.common.base.Objects;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.model.BillItem;
import java.math.BigDecimal;
import java.util.List;

public class PreInvoiceLimit {
    private final BigDecimal ERROR_AMOUNT = new BigDecimal("1.27");
    private BigDecimal limitAmount;
    private boolean limitIsAmountWithTax;
    private int limitLine;
    private BigDecimal currentTotalAmount;
    private BigDecimal currentTotalError;
    private int currentLine;

    public PreInvoiceLimit(BigDecimal limitAmount, boolean limitIsAmountWithTax, int limitLine) {
        this.limitAmount = limitAmount;
        this.limitIsAmountWithTax = limitIsAmountWithTax;
        this.limitLine = limitLine;
        this.currentTotalAmount = BigDecimal.ZERO;
        this.currentTotalError = BigDecimal.ZERO;
        this.currentLine = 0;
    }

    public PreInvoiceLimit(SplitGroupLimit splitGroupLimit) {
        this.limitAmount = splitGroupLimit.getLimitAmount();
        this.limitIsAmountWithTax = splitGroupLimit.isLimitIsAmountWithTax();
        this.limitLine = splitGroupLimit.getLimitLine();
        this.currentTotalAmount = BigDecimal.ZERO;
        this.currentTotalError = BigDecimal.ZERO;
        this.currentLine = 0;
    }

    boolean canAdd() {
        return this.currentTotalAmount.compareTo(this.limitAmount) <= 0 && this.currentLine < this.limitLine && this.currentTotalError.compareTo(this.ERROR_AMOUNT) <= 0;
    }

    public boolean canAddItem(BillItem billItem) {
        BigDecimal amount = this.getBillItemAmount(billItem);
        BigDecimal errorAmount = this.getBillItemErrorAmount(billItem);
        int line = this.getBillItemLine(billItem);
        return this.currentTotalAmount.add(amount).compareTo(this.limitAmount) <= 0 && this.currentLine + line <= this.limitLine && this.currentTotalError.add(errorAmount).compareTo(this.ERROR_AMOUNT) <= 0;
    }

    public void addItem(BillItem billItem) {
        BigDecimal amount = this.getBillItemAmount(billItem);
        BigDecimal errorAmount = this.getBillItemErrorAmount(billItem);
        int line = this.getBillItemLine(billItem);
        this.currentTotalAmount = this.currentTotalAmount.add(amount);
        this.currentLine += line;
        this.currentTotalError = this.currentTotalError.add(errorAmount);
    }

    public boolean canAddInvoice(List<BillItem> billItems) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalErrorAmount = BigDecimal.ZERO;
        int totalLine = 0;
        for (BillItem billItem : billItems) {
            BigDecimal amount = this.getBillItemAmount(billItem);
            BigDecimal errorAmount = this.getBillItemErrorAmount(billItem);
            int line = this.getBillItemLine(billItem);
            totalAmount = totalAmount.add(amount);
            totalErrorAmount = totalErrorAmount.add(errorAmount);
            if (this.currentTotalAmount.add(totalAmount).compareTo(this.limitAmount) <= 0 && this.currentLine + (totalLine += line) <= this.limitLine && this.currentTotalError.add(totalErrorAmount).compareTo(this.ERROR_AMOUNT) <= 0) continue;
            return false;
        }
        return true;
    }

    public void addInvoice(List<BillItem> billItems) {
        billItems.forEach(this::addItem);
    }

    private int getBillItemLine(BillItem billItem) {
        if (billItem.getDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
            return 2;
        }
        return 1;
    }

    private BigDecimal getBillItemErrorAmount(BillItem billItem) {
        return billItem.getTaxAmount().subtract(billItem.getDiscountTax()).subtract(billItem.getAmountWithoutTax().subtract(billItem.getDiscountWithoutTax()).multiply(billItem.getTaxRate())).abs();
    }

    private BigDecimal getBillItemAmount(BillItem billItem) {
        BigDecimal result = this.limitIsAmountWithTax ? billItem.getAmountWithTax().subtract(billItem.getDiscountWithTax()) : billItem.getAmountWithoutTax().subtract(billItem.getDiscountWithoutTax());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreInvoiceLimit that = (PreInvoiceLimit)o;
        return this.currentLine == that.currentLine && this.currentTotalError.compareTo(that.currentTotalError) == 0 && this.currentTotalAmount.compareTo(that.currentTotalAmount) == 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.currentTotalAmount, this.currentTotalError, this.currentLine});
    }
}

