/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.ProductMinerals;
import com.xforceplus.phoenix.split.constant.SpecialAreaUnitEnum;
import com.xforceplus.phoenix.split.constant.SpecialGoodsTaxNoEnum;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.CreatePreInvoiceParam;
import com.xforceplus.phoenix.split.model.ItemTypeCodeEnum;
import com.xforceplus.phoenix.split.model.PriceMethod;
import com.xforceplus.phoenix.split.model.RedReasonEnum;
import com.xforceplus.phoenix.split.model.SplitPreInvoiceInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.AmountSplitRuleUtils;
import com.xforceplus.phoenix.split.service.BasicDataProcessService;
import com.xforceplus.phoenix.split.service.BigDecimalUtils;
import com.xforceplus.phoenix.split.service.impl.Bill2PreInvoiceService;
import com.xforceplus.phoenix.split.service.impl.DefaultSplitBillItemAmountServiceImpl;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SplitMainHandleService {
    private static final int DEFAULT_UNIT_PRICE_SCALE = 15;
    public static final String UNIT_PRICE_ERROR_MESSAGE = "\u53d1\u7968\u5355\u4ef7\u5fc5\u586b";
    public static final String QUANTITY_UNIT_ERROR_MESSAGE = "\u53d1\u7968\u5355\u4f4d\u5fc5\u586b";
    public static final String QUANTITY_UNIT_ERROR_VALUE_MESSAGE = "\u53d1\u7968\u5355\u4f4d\u6709\u8bef";
    public static final String QUANTITY_ERROR_MESSAGE = "\u53d1\u7968\u6570\u91cf\u5fc5\u586b";
    public static final String BUILDING_ADDRESS_KEY = "placeOfOccurrence";
    public static final String PROPERTY_ADDRESS_KEY = "realEstateAddress";
    public static final String JDC_INVOICE_TYPE_KEY = "invoiceType";
    public static final String JDC_ITEM_SPEC_KEY = "itemSpec";
    public static final String JDC_ITEM_QUANTITY_UNIT = "\u8f86";
    public static final String JDC_INVOICE_TYPE_ERROR_MESSAGE = "\u5f53\u524d\u5f00\u5177\u7684\u53d1\u7968\u4e3a\u673a\u52a8\u8f66\u4e13\u7528\u53d1\u7968\uff0c\u8bf7\u4fee\u6539\u53d1\u7968\u7c7b\u578b\u540e\u63d0\u4ea4";
    public static final String JDC_ITEM_SPEC_ERROR_MESSAGE = "\u5f53\u524d\u5f00\u5177\u7684\u53d1\u7968\u4e3a\u673a\u52a8\u8f66\u4e13\u7528\u53d1\u7968\uff0c\u5fc5\u987b\u586b\u5199\u89c4\u683c\u578b\u53f7";
    public static final String JDC_ITEM_QUANTITY_ERROR_MESSAGE = "\u5f53\u524d\u5f00\u5177\u7684\u53d1\u7968\u4e3a\u673a\u52a8\u8f66\u4e13\u7528\u53d1\u7968\uff0c\u6570\u91cf\u5fc5\u987b\u4e3a\u975e\u96f6\u6574\u6570";
    public static final String JDC_ITEM_QUANTITY_UNIT_ERROR_MESSAGE = "\u5f53\u524d\u5f00\u5177\u7684\u53d1\u7968\u4e3a\u673a\u52a8\u8f66\u4e13\u7528\u53d1\u7968\uff0c\u6570\u91cf\u5355\u4f4d\u5fc5\u987b\u4e3a\u8f86";
    public static final String GOODS_TAX_NO = "3040502020200000000";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private Bill2PreInvoiceService bill2PreInvoiceService;
    @Autowired
    private BasicDataProcessService basicDataProcessService;
    @Value(value="${config.goods-tax-no.validation.mode}")
    private String goodsTaxNoMode;

    public List<SplitPreInvoiceInfo> splitAndAssembleInvoice(CreatePreInvoiceParam createPreInvoiceParam, TaxDeviceType taxDeviceType, String txId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.processBillItem(createPreInvoiceParam.getBillInfo(), createPreInvoiceParam.getRule(), txId);
        List<SplitPreInvoiceInfo> data = this.bill2PreInvoiceService.createPreInvoiceFromBill(createPreInvoiceParam.getBillInfo(), createPreInvoiceParam.getRule(), org.apache.commons.lang3.StringUtils.isBlank((CharSequence)createPreInvoiceParam.getRuleCode()) ? "default" : createPreInvoiceParam.getRuleCode(), taxDeviceType);
        this.logger.info("SplitMainHandleService.splitAndAssembleInvoice.generate pre_invoice txId = {} elapsed time = {} ms, pre invoice size:{}", new Object[]{txId, stopwatch.elapsed().toMillis(), data.size()});
        return data;
    }

    public void processBillItem(BillInfo billInfo, SplitRule rule, String txId) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (rule.getUnitPriceScale() == null) {
            rule.setUnitPriceScale(Integer.valueOf(15));
        }
        List items = billInfo.getBillItems();
        PriceMethod priceMethod = PriceMethod.value((Integer)billInfo.getPriceMethod());
        rule.setPriceMethod(priceMethod);
        for (BillItem billItem : items) {
            this.adjustBillItem(billItem, rule);
            this.validateInvoiceItem(billItem, rule);
            this.validateSpecialInvoice(billInfo, billItem, rule);
            this.handleItemAmount(billItem, rule, priceMethod);
        }
        this.reCalculateTotalAmount(rule, billInfo, items);
        this.logger.info("SplitMainHandleService.processBillItem txId={} elapsed time = {} ms, billItem size:{}", new Object[]{txId, stopwatch.elapsed().toMillis(), items.size()});
    }

    public void handleItemAmount(BillItem billItem, SplitRule rule, PriceMethod priceMethod) {
        this.calculateInnerAmount(billItem, rule);
        this.validateItemAmount(billItem, rule);
        this.reCalculateOriginalTaxAmount(rule, billItem, priceMethod);
        this.reCalculateUnitPrice(billItem, rule);
        this.basicDataProcessService.adjustUnitPrice(billItem, rule);
    }

    private void adjustBillItem(BillItem billItem, SplitRule rule) {
        this.adjustBillItemAmount(billItem);
        this.adjustBillItemName(billItem, rule);
        this.adjustBillItemGoodsTaxNo(billItem, rule);
    }

    public void adjustBillItemGoodsTaxNo(BillItem billItem, SplitRule rule) {
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        if (SpecialGoodsTaxNoEnum.isIntangibleAssets(billItem.getGoodsTaxNo())) {
            if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource)) {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.goodsTaxNoMode) && this.goodsTaxNoMode.equals("1")) {
                    billItem.setGoodsTaxNo(SpecialGoodsTaxNoEnum.INTANGIBLE_ASSETS_OLD.getValue());
                } else {
                    billItem.setGoodsTaxNo(SpecialGoodsTaxNoEnum.INTANGIBLE_ASSETS_NEW.getValue());
                }
            } else if (TaxInvoiceSourceEnum.SK.getValue().equals(taxInvoiceSource)) {
                billItem.setGoodsTaxNo(SpecialGoodsTaxNoEnum.INTANGIBLE_ASSETS_NEW.getValue());
            }
        }
    }

    public void adjustBillItemName(BillItem billItem, SplitRule rule) {
        boolean removeIllegalItemNameCharacter = rule.isRemoveIllegalItemNameCharacter();
        if (removeIllegalItemNameCharacter) {
            String itemName = billItem.getItemName();
            try {
                String gbkItemName = new String(itemName.getBytes("gbk"), "gbk");
                String utf8ItemName = new String(itemName.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
                if (!gbkItemName.equals(utf8ItemName)) {
                    StringBuilder sb = new StringBuilder();
                    char[] gbkChars = gbkItemName.toCharArray();
                    char[] utf8Chars = utf8ItemName.toCharArray();
                    for (int i = 0; i < gbkChars.length; ++i) {
                        char gbkChar = gbkChars[i];
                        char utfChar = utf8Chars[i];
                        if (gbkChar != utfChar) continue;
                        sb.append(gbkChar);
                    }
                    billItem.setItemName(sb.toString().trim());
                }
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void adjustBillItemAmount(BillItem billItem) {
        BigDecimal unitPrice = billItem.getUnitPrice();
        billItem.setUnitPrice(unitPrice.stripTrailingZeros());
    }

    public void reCalculateUnitPrice(BillItem billItem, SplitRule rule) {
    }

    public void validateSpecialInvoice(BillInfo billInfo, BillItem billItem, SplitRule rule) {
        String redReason = billInfo.getRedReason();
        RedReasonEnum redReasonEnum = !StringUtils.isEmpty((Object)redReason) ? RedReasonEnum.fromValue((String)redReason) : null;
        this.validateItemTypeCodeCPY(billItem, redReasonEnum);
        this.validateItemTypeCodeKCP(billItem, redReasonEnum);
        this.validateSpecialItemTypeCode(billItem, rule);
    }

    public void validateItemTypeCodeCPY(BillItem billItem, RedReasonEnum redReasonEnum) {
        boolean isRedItem;
        String itemTypeCode = billItem.getItemTypeCode();
        boolean bl = isRedItem = billItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) < 0;
        if (ItemTypeCodeEnum.OIL.getValue().equals(itemTypeCode) && (!isRedItem || redReasonEnum != null && RedReasonEnum.SALES_ALLOWANCE != redReasonEnum)) {
            if (billItem.getQuantity() == null || BigDecimal.ZERO.compareTo(billItem.getQuantity()) == 0) {
                throw new SplitBizException(ItemTypeCodeEnum.OIL.getDescription() + QUANTITY_ERROR_MESSAGE);
            }
            if (billItem.getUnitPrice() == null || BigDecimal.ZERO.compareTo(billItem.getUnitPrice()) == 0) {
                throw new SplitBizException(ItemTypeCodeEnum.OIL.getDescription() + UNIT_PRICE_ERROR_MESSAGE);
            }
            if (StringUtils.isEmpty((Object)billItem.getQuantityUnit())) {
                throw new SplitBizException(ItemTypeCodeEnum.OIL.getDescription() + QUANTITY_UNIT_ERROR_MESSAGE);
            }
        }
    }

    public void validateItemTypeCodeJDC(BillItem billItem, String invoiceType, SplitRule rule) {
        String itemTypeCode = billItem.getItemTypeCode();
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)TaxInvoiceSourceEnum.QD.getValue(), (CharSequence)taxInvoiceSource) && org.apache.commons.lang3.StringUtils.equals((CharSequence)ItemTypeCodeEnum.VEHICLE.getValue(), (CharSequence)itemTypeCode) && Lists.newArrayList((Object[])new String[]{InvoiceType.SE.value(), InvoiceType.SPECIAL.value()}).contains(invoiceType)) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)billItem.getItemSpec())) {
                throw new SplitBizException(JDC_ITEM_SPEC_ERROR_MESSAGE);
            }
            if (!BigDecimalUtils.isQuanlityOfJdc(billItem.getQuantity())) {
                throw new SplitBizException(JDC_ITEM_QUANTITY_ERROR_MESSAGE);
            }
            if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)JDC_ITEM_QUANTITY_UNIT, (CharSequence)billItem.getQuantityUnit())) {
                throw new SplitBizException(JDC_ITEM_QUANTITY_UNIT_ERROR_MESSAGE);
            }
        }
    }

    public void validateItemTypeCodeKCP(BillItem billItem, RedReasonEnum redReasonEnum) {
        String itemTypeCode = billItem.getItemTypeCode();
        String goodsTaxNo = billItem.getGoodsTaxNo();
        if (ItemTypeCodeEnum.MINERALS.getValue().equals(itemTypeCode)) {
            boolean isRedItem;
            boolean bl = isRedItem = billItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) < 0;
            if (!isRedItem) {
                if (billItem.getQuantity() == null || BigDecimal.ZERO.compareTo(billItem.getQuantity()) == 0) {
                    throw new SplitBizException(ItemTypeCodeEnum.MINERALS.getDescription() + QUANTITY_ERROR_MESSAGE);
                }
                if (billItem.getUnitPrice() == null || BigDecimal.ZERO.compareTo(billItem.getUnitPrice()) == 0) {
                    throw new SplitBizException(ItemTypeCodeEnum.MINERALS.getDescription() + UNIT_PRICE_ERROR_MESSAGE);
                }
                if (StringUtils.isEmpty((Object)billItem.getQuantityUnit())) {
                    throw new SplitBizException(ItemTypeCodeEnum.MINERALS.getDescription() + QUANTITY_UNIT_ERROR_MESSAGE);
                }
                if (!ProductMinerals.getMineralQuantityUnits().contains(billItem.getQuantityUnit()) || "\u6876".equals(billItem.getQuantityUnit()) && !ProductMinerals.getMineralOilGoodsTaxNos().contains(goodsTaxNo)) {
                    throw new SplitBizException(ItemTypeCodeEnum.MINERALS.getDescription() + QUANTITY_UNIT_ERROR_VALUE_MESSAGE);
                }
            } else if (redReasonEnum != null && RedReasonEnum.SALES_ALLOWANCE != redReasonEnum) {
                if (billItem.getQuantity() == null || BigDecimal.ZERO.compareTo(billItem.getQuantity()) == 0) {
                    throw new SplitBizException(ItemTypeCodeEnum.MINERALS.getDescription() + QUANTITY_ERROR_MESSAGE);
                }
                if (StringUtils.isEmpty((Object)billItem.getQuantityUnit())) {
                    throw new SplitBizException(ItemTypeCodeEnum.MINERALS.getDescription() + QUANTITY_UNIT_ERROR_MESSAGE);
                }
            }
        }
    }

    public void validateSpecialItemTypeCode(BillItem billItem, SplitRule rule) {
        List additions;
        boolean isRedItem;
        List specialAdditions = billItem.getSpecialAdditions();
        boolean bl = isRedItem = billItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) < 0;
        if (rule.getTaxInvoiceSource().equals(TaxInvoiceSourceEnum.QD.getValue()) && ItemTypeCodeEnum.isAllElectronicPropertySpecialInvoice((String)billItem.getItemTypeCode())) {
            additions = billItem.getSpecialAdditions();
            Optional.ofNullable(additions).filter(list -> !list.isEmpty()).map(list -> ((Map)list.get(0)).get("areaUnit")).map(areaUnitObj -> SpecialAreaUnitEnum.getEnum(String.valueOf(areaUnitObj))).ifPresent(areaUnitEnum -> billItem.setQuantityUnit(areaUnitEnum.getDescription()));
        }
        if (rule.getTaxInvoiceSource().equals(TaxInvoiceSourceEnum.QD.getValue()) && ItemTypeCodeEnum.isAllElectronicSpecialInvoice((String)billItem.getItemTypeCode()) && !isRedItem) {
            if (CollectionUtils.isEmpty((Collection)specialAdditions)) {
                throw new SplitBizException("\u7279\u6b8a\u4e1a\u52a1\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a ");
            }
            if (ItemTypeCodeEnum.PROPERTY_RENT.getValue().equals(billItem.getItemTypeCode()) || ItemTypeCodeEnum.PROPERTY_SALE.getValue().equals(billItem.getItemTypeCode())) {
                boolean hasNotAddress = specialAdditions.stream().anyMatch(e -> e.get(PROPERTY_ADDRESS_KEY) == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)e.get(PROPERTY_ADDRESS_KEY).toString()));
                if (!hasNotAddress) {
                    boolean containAddressKeyWord = specialAdditions.stream().map(e -> e.get(PROPERTY_ADDRESS_KEY)).filter(Objects::nonNull).allMatch(e -> {
                        List addressKeyWords = ItemTypeCodeEnum.specialInvoiceAddressKeyWord();
                        for (String word : addressKeyWords) {
                            if (!String.valueOf(e).contains(word)) continue;
                            return true;
                        }
                        return false;
                    });
                    if (!containAddressKeyWord) {
                        throw new SplitBizException("\u7279\u6b8a\u4e1a\u52a1\u8be6\u7ec6\u5730\u5740\u5fc5\u987b\u5305\u542b\u201c\u8857\u3001\u8def\u3001\u6751\u3001\u4e61\u3001\u9547\u3001\u9053\u3001\u5df7\u3001\u53f7\u201d \u5173\u952e\u8bcd\u4e4b\u4e00 ");
                    }
                } else {
                    throw new SplitBizException("\u4e0d\u52a8\u4ea7\u4e1a\u52a1\u8be6\u7ec6\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a ");
                }
            }
        }
        if (rule.getTaxInvoiceSource().equals(TaxInvoiceSourceEnum.QD.getValue()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)ItemTypeCodeEnum.PROPERTY_RENT.getValue(), (CharSequence)billItem.getItemTypeCode())) {
            additions = billItem.getSpecialAdditions();
            Optional.ofNullable(additions).filter(list -> !list.isEmpty()).map(list -> ((Map)list.get(0)).get("areaUnit")).map(areaUnitObj -> SpecialAreaUnitEnum.getEnum(String.valueOf(areaUnitObj))).ifPresent(areaUnitEnum -> billItem.setQuantityUnit(areaUnitEnum.getDescription()));
        }
    }

    public void validateInvoiceItem(BillItem billItem, SplitRule rule) {
        String itemName = billItem.getItemName();
        String itemShortName = billItem.getItemShortName();
        String goodsTaxNo = billItem.getGoodsTaxNo();
        BigDecimal taxRate = billItem.getTaxRate();
        if (StringUtils.isEmpty((Object)itemName) && !rule.isIgnoreBillItemName()) {
            throw new SplitBizException("\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)itemShortName) && !rule.isIgnoreBillItemShortName()) {
            throw new SplitBizException("\u7a0e\u7f16\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)goodsTaxNo) && !rule.isIgnoreBillItemGoodsTaxNo()) {
            throw new SplitBizException("\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (taxRate == null && !rule.isIgnoreBillItemTaxRate()) {
            throw new SplitBizException("\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (SpecialGoodsTaxNoEnum.INTANGIBLE_ASSETS_OLD.getValue().equals(goodsTaxNo) && (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.goodsTaxNoMode) || !this.goodsTaxNoMode.equals("1"))) {
            throw new SplitBizException("\u7a0e\u7f16\u4e0d\u5408\u6cd5");
        }
    }

    public void calculateInnerAmount(BillItem billItem, SplitRule rule) {
        this.formatOuterPrice2Inner(billItem, rule);
        billItem.setAmountWithoutTax(billItem.getAmountWithoutTax().subtract(billItem.getInnerDiscountWithoutTax()).subtract(billItem.getInnerPrepayAmountWithoutTax()));
        if (billItem.getInnerDiscountWithoutTax().compareTo(BigDecimal.ZERO) != 0 || billItem.getInnerPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) != 0) {
            this.processPriceOrQuantity(billItem, rule);
        }
        billItem.setTaxAmount(billItem.getTaxAmount().subtract(billItem.getInnerPrepayAmountTax()).subtract(billItem.getInnerDiscountTax()));
        billItem.setAmountWithTax(billItem.getTaxAmount().add(billItem.getAmountWithoutTax()));
        billItem.setDiscountWithoutTax(billItem.getOutterDiscountWithoutTax().add(billItem.getOutterPrepayAmountWithoutTax()));
        billItem.setDiscountWithTax(billItem.getOutterDiscountWithTax().add(billItem.getOutterPrepayAmountWithTax()));
        billItem.setDiscountTax(billItem.getOutterDiscountTax().add(billItem.getOutterPrepayAmountTax()));
        billItem.setInnerDiscountWithoutTax(BigDecimal.ZERO);
        billItem.setInnerDiscountTax(BigDecimal.ZERO);
        billItem.setInnerDiscountWithTax(BigDecimal.ZERO);
        billItem.setInnerPrepayAmountWithTax(BigDecimal.ZERO);
        billItem.setInnerPrepayAmountTax(BigDecimal.ZERO);
        billItem.setInnerPrepayAmountWithoutTax(BigDecimal.ZERO);
    }

    public void reCalculateOriginalTaxAmount(SplitRule rule, BillItem billItem, PriceMethod priceMethod) {
        boolean isRedItem;
        boolean forceBackCalculateTaxAmount = rule.isForceBackCalculateTaxAmount();
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        boolean bl = isRedItem = billItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) < 0;
        if (TaxInvoiceSourceEnum.SK.getValue().equals(taxInvoiceSource)) {
            if (priceMethod == null) {
                throw new SplitBizException("\u8ba1\u4ef7\u65b9\u5f0f\u5fc5\u586b");
            }
            if (billItem.getQuantity() != null && billItem.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                int scale = billItem.getQuantity().stripTrailingZeros().scale();
                BigDecimal totalAmount = billItem.getAmountWithoutTax();
                if (scale > 6) {
                    BigDecimal recalculatedQuantity = totalAmount.divide(billItem.getUnitPrice(), 6, RoundingMode.HALF_UP);
                    billItem.setQuantity(recalculatedQuantity);
                    this.logger.info("scale:{},amount:{},salesbillItemId:{}", new Object[]{recalculatedQuantity, totalAmount, billItem.getSalesbillItemId()});
                }
            }
        }
        if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource) && forceBackCalculateTaxAmount && !isRedItem) {
            if (priceMethod == null) {
                throw new SplitBizException("\u8ba1\u4ef7\u65b9\u5f0f\u5fc5\u586b");
            }
            if (priceMethod == PriceMethod.WITHOUT_TAX) {
                BigDecimal amountWithoutTax = billItem.getAmountWithoutTax();
                BigDecimal taxRate = billItem.getTaxRate();
                BigDecimal newTaxAmount = amountWithoutTax.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
                BigDecimal newAmountWithTax = amountWithoutTax.add(newTaxAmount);
                billItem.setTaxAmount(newTaxAmount);
                billItem.setAmountWithTax(newAmountWithTax);
                BigDecimal outerDiscountWithoutTax = billItem.getOutterDiscountWithoutTax();
                BigDecimal newOuterDiscountTax = outerDiscountWithoutTax.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
                BigDecimal newOuterDiscountWithTax = outerDiscountWithoutTax.add(newOuterDiscountTax);
                billItem.setOutterDiscountTax(newOuterDiscountTax);
                billItem.setOutterDiscountWithTax(newOuterDiscountWithTax);
                BigDecimal outerPrepayAmountWithoutTax = billItem.getOutterPrepayAmountWithoutTax();
                BigDecimal newOuterPrePaymentTax = outerPrepayAmountWithoutTax.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
                BigDecimal newOuterPrePaymentWithTax = outerPrepayAmountWithoutTax.add(newOuterPrePaymentTax);
                billItem.setOutterPrepayAmountTax(newOuterPrePaymentTax);
                billItem.setOutterPrepayAmountWithTax(newOuterPrePaymentWithTax);
            } else if (priceMethod == PriceMethod.WITH_TAX) {
                BigDecimal taxRate = billItem.getTaxRate();
                BigDecimal newTaxRate = taxRate.add(BigDecimal.ONE);
                BigDecimal amountWithTax = billItem.getAmountWithTax();
                BigDecimal newTaxAmount = amountWithTax.multiply(taxRate).divide(newTaxRate, 2, RoundingMode.HALF_UP);
                BigDecimal newAmountWithoutTax = amountWithTax.subtract(newTaxAmount);
                billItem.setAmountWithoutTax(newAmountWithoutTax);
                billItem.setTaxAmount(newTaxAmount);
                BigDecimal outerDiscountWithTax = billItem.getOutterDiscountWithTax();
                BigDecimal newOuterDiscountWithoutTax = outerDiscountWithTax.divide(newTaxRate, 2, RoundingMode.HALF_UP);
                BigDecimal newOuterDiscountTax = outerDiscountWithTax.subtract(newOuterDiscountWithoutTax);
                billItem.setOutterDiscountWithoutTax(newOuterDiscountWithoutTax);
                billItem.setOutterDiscountTax(newOuterDiscountTax);
                BigDecimal outerPrePaymentWithTax = billItem.getOutterPrepayAmountWithTax();
                BigDecimal newOuterPrePaymentWithoutTax = outerPrePaymentWithTax.divide(newTaxRate, 2, RoundingMode.HALF_UP);
                BigDecimal newOuterPrePaymentTax = outerPrePaymentWithTax.subtract(newOuterPrePaymentWithoutTax);
                billItem.setOutterPrepayAmountWithoutTax(newOuterPrePaymentWithoutTax);
                billItem.setOutterPrepayAmountTax(newOuterPrePaymentTax);
                if (BigDecimal.ZERO.compareTo(newAmountWithoutTax) != 0) {
                    this.processPriceOrQuantity(billItem, rule);
                }
            }
            billItem.setDiscountWithoutTax(billItem.getOutterDiscountWithoutTax().add(billItem.getOutterPrepayAmountWithoutTax()));
            billItem.setDiscountWithTax(billItem.getOutterDiscountWithTax().add(billItem.getOutterPrepayAmountWithTax()));
            billItem.setDiscountTax(billItem.getOutterDiscountTax().add(billItem.getOutterPrepayAmountTax()));
        }
    }

    public void validateItemAmount(BillItem billItem, SplitRule rule) {
        BigDecimal amountWithoutTax;
        BigDecimal unitPrice = billItem.getUnitPrice();
        BigDecimal quantity = billItem.getQuantity();
        boolean enableAdvancedValidation = rule.isEnableAdvancedValidation();
        boolean forceBackCalculateTaxAmount = rule.isForceBackCalculateTaxAmount();
        boolean isSpecialAddition = enableAdvancedValidation;
        if (isSpecialAddition) {
            amountWithoutTax = billItem.getAmountWithoutTax();
            BigDecimal taxAmount = billItem.getTaxAmount();
            BigDecimal taxRate = billItem.getTaxRate();
            boolean isRedItem = amountWithoutTax.compareTo(BigDecimal.ZERO) < 0;
            BigDecimal newTaxAmount = amountWithoutTax.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
            BigDecimal offsetAmount = BigDecimal.valueOf(0.06);
            if (newTaxAmount.subtract(taxAmount).abs().compareTo(offsetAmount) > 0 && !forceBackCalculateTaxAmount) {
                throw new SplitBizException(String.format("\u660e\u7ec6id = [%s]  \u540d\u79f0 [%s] \u4e0d\u542b\u7a0e\u91d1\u989d[%s] * \u7a0e\u7387[%s] \u4e0e\u7a0e\u989d[%s] \u8d85\u8fc7\u8bef\u5dee[%s] ", billItem.getSalesbillItemId(), billItem.getItemName(), billItem.getAmountWithoutTax(), billItem.getTaxRate(), billItem.getTaxAmount(), offsetAmount));
            }
            BigDecimal outterDiscountWithoutTax = billItem.getDiscountWithoutTax();
            BigDecimal outterDiscountTax = billItem.getOutterDiscountTax();
            BigDecimal newOutterDiscountTax = outterDiscountWithoutTax.multiply(taxRate).setScale(2, RoundingMode.HALF_UP);
            if (newOutterDiscountTax.subtract(outterDiscountTax).abs().compareTo(offsetAmount) > 0 && !forceBackCalculateTaxAmount) {
                throw new SplitBizException(String.format("\u660e\u7ec6id = [%s]  \u540d\u79f0 [%s] \u4ef7\u5916\u6298\u6263\u4e0d\u542b\u7a0e\u91d1\u989d[%s] * \u7a0e\u7387[%s] \u4e0e\u4ef7\u5916\u6298\u6263\u7a0e\u989d[%s] \u8d85\u8fc7\u8bef\u5dee[%s] ", billItem.getSalesbillItemId(), billItem.getItemName(), billItem.getDiscountWithoutTax(), billItem.getTaxRate(), billItem.getOutterDiscountTax(), offsetAmount));
            }
        }
        if (unitPrice.compareTo(BigDecimal.ZERO) != 0 && quantity.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal offsetAmount;
            amountWithoutTax = billItem.getAmountWithoutTax();
            BigDecimal newAmountWithoutTax = unitPrice.multiply(quantity).setScale(2, RoundingMode.HALF_UP);
            BigDecimal bigDecimal = offsetAmount = isSpecialAddition ? BigDecimal.valueOf(0.01) : BigDecimal.ZERO;
            if (amountWithoutTax.subtract(newAmountWithoutTax).abs().compareTo(offsetAmount) > 0 && !forceBackCalculateTaxAmount) {
                throw new SplitBizException(String.format("\u660e\u7ec6id = [%s]  \u540d\u79f0 [%s] \u5355\u4ef7[%s]*\u6570\u91cf[%s]\u53d6\u4e24\u4f4d\u5c0f\u6570 \u4e0e\u4e0d\u542b\u7a0e\u91d1\u989d[%s]\u4e0d\u76f8\u7b49", billItem.getSalesbillItemId(), billItem.getItemName(), billItem.getUnitPrice(), billItem.getQuantity(), billItem.getAmountWithoutTax()));
            }
        }
    }

    public void reCalculateTotalAmount(SplitRule rule, BillInfo billInfo, List<BillItem> items) {
        boolean forceBackCalculateTaxAmount = rule.isForceBackCalculateTaxAmount();
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource) && forceBackCalculateTaxAmount) {
            String salesbillId = billInfo.getSalesbillId();
            String salesbillNo = billInfo.getSalesbillNo();
            Long batchNo = billInfo.getBatchNo();
            this.logger.info("reCalculateTotalAmount.calculateAmount.salesbillId:{},salesbillNo:{},batchNo:{}", new Object[]{salesbillId, salesbillNo, batchNo});
            BigDecimal totalTaxAmount = BigDecimal.ZERO;
            BigDecimal totalAmountWithoutTax = BigDecimal.ZERO;
            BigDecimal totalAmountWithTax = BigDecimal.ZERO;
            for (BillItem item : items) {
                totalTaxAmount = totalTaxAmount.add(item.getTaxAmount());
                totalAmountWithoutTax = totalAmountWithoutTax.add(item.getAmountWithoutTax());
                totalAmountWithTax = totalAmountWithTax.add(item.getAmountWithTax());
            }
            billInfo.setAmountWithoutTax(totalAmountWithoutTax);
            billInfo.setAmountWithTax(totalAmountWithTax);
            billInfo.setTaxAmount(totalTaxAmount);
        }
    }

    public void formatOuterPrice2Inner(BillItem billItem, SplitRule splitRule) {
        boolean hasOuterPrepayment;
        boolean hideOuterAmount = splitRule.isHideOuterAmount();
        boolean hasOuterDiscount = billItem.getOutterDiscountWithoutTax().compareTo(BigDecimal.ZERO) != 0;
        boolean bl = hasOuterPrepayment = billItem.getOutterPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) != 0;
        if (hideOuterAmount && hasOuterDiscount || this.compareWhenAmountPosAndOutDiscountPosAndSubtractNeg(billItem.getAmountWithoutTax(), billItem.getOutterDiscountWithoutTax()).booleanValue() || this.compareWhenAmountPosAndOutDiscountNeg(billItem.getAmountWithoutTax(), billItem.getOutterDiscountWithoutTax()).booleanValue() || this.compareWhenAmountNegAndOutDiscountPos(billItem.getAmountWithoutTax(), billItem.getOutterDiscountWithoutTax()).booleanValue() || this.compareWhenAmountNegAndOutDiscountNeg(billItem.getAmountWithoutTax(), billItem.getOutterDiscountWithoutTax()).booleanValue()) {
            billItem.setInnerDiscountTax(billItem.getInnerDiscountTax().add(billItem.getOutterDiscountTax()));
            billItem.setInnerDiscountWithoutTax(billItem.getInnerDiscountWithoutTax().add(billItem.getOutterDiscountWithoutTax()));
            billItem.setInnerDiscountWithTax(billItem.getInnerDiscountWithTax().add(billItem.getOutterDiscountWithTax()));
            billItem.setOutterDiscountTax(BigDecimal.ZERO);
            billItem.setOutterDiscountWithTax(BigDecimal.ZERO);
            billItem.setOutterDiscountWithoutTax(BigDecimal.ZERO);
        }
        if (hideOuterAmount && hasOuterPrepayment || this.compareWhenAmountPosAndOutDiscountPosAndSubtractNeg(billItem.getAmountWithoutTax(), billItem.getOutterPrepayAmountWithoutTax()).booleanValue() || this.compareWhenAmountPosAndOutDiscountNeg(billItem.getAmountWithoutTax(), billItem.getOutterPrepayAmountWithoutTax()).booleanValue() || this.compareWhenAmountNegAndOutDiscountPos(billItem.getAmountWithoutTax(), billItem.getOutterPrepayAmountWithoutTax()).booleanValue() || this.compareWhenAmountNegAndOutDiscountNeg(billItem.getAmountWithoutTax(), billItem.getOutterPrepayAmountWithoutTax()).booleanValue()) {
            billItem.setInnerPrepayAmountTax(billItem.getInnerPrepayAmountTax().add(billItem.getOutterPrepayAmountTax()));
            billItem.setInnerPrepayAmountWithoutTax(billItem.getInnerPrepayAmountWithoutTax().add(billItem.getOutterPrepayAmountWithoutTax()));
            billItem.setInnerPrepayAmountWithTax(billItem.getInnerPrepayAmountWithTax().add(billItem.getOutterPrepayAmountWithTax()));
            billItem.setOutterPrepayAmountWithTax(BigDecimal.ZERO);
            billItem.setOutterPrepayAmountWithoutTax(BigDecimal.ZERO);
            billItem.setOutterPrepayAmountTax(BigDecimal.ZERO);
        }
    }

    private Boolean compareWhenAmountPosAndOutDiscountPosAndSubtractNeg(BigDecimal amount, BigDecimal discount) {
        return amount.compareTo(BigDecimal.ZERO) > 0 && discount.compareTo(BigDecimal.ZERO) > 0 && amount.subtract(discount).compareTo(BigDecimal.ZERO) < 0;
    }

    private Boolean compareWhenAmountPosAndOutDiscountNeg(BigDecimal amount, BigDecimal discount) {
        return amount.compareTo(BigDecimal.ZERO) > 0 && discount.compareTo(BigDecimal.ZERO) < 0;
    }

    private Boolean compareWhenAmountNegAndOutDiscountPos(BigDecimal amount, BigDecimal discount) {
        return amount.compareTo(BigDecimal.ZERO) < 0 && discount.compareTo(BigDecimal.ZERO) > 0;
    }

    private Boolean compareWhenAmountNegAndOutDiscountNeg(BigDecimal amount, BigDecimal discount) {
        return amount.compareTo(BigDecimal.ZERO) < 0 && discount.compareTo(BigDecimal.ZERO) < 0;
    }

    public void processPriceOrQuantity(BillItem billItem, SplitRule rule) {
        BigDecimal newAmount;
        int unitPriceScale = rule.getUnitPriceScale();
        if (this.backCalculateUnitPrice(rule, billItem)) {
            BigDecimal newUnitPrice = billItem.getAmountWithoutTax().divide(billItem.getQuantity(), unitPriceScale, RoundingMode.HALF_UP);
            billItem.setUnitPrice(newUnitPrice);
        }
        if (this.backCalculateQuantity(rule, billItem)) {
            BigDecimal newQuantity;
            if (this.backCalculateQuantityRounding(rule, billItem)) {
                newQuantity = billItem.getAmountWithoutTax().divide(billItem.getUnitPrice(), 0, RoundingMode.HALF_UP);
                if (newQuantity.compareTo(BigDecimal.ZERO) == 0) {
                    newQuantity = DefaultSplitBillItemAmountServiceImpl.MIN_QUANTITY;
                }
                BigDecimal newUnitPrice = billItem.getAmountWithoutTax().divide(newQuantity, unitPriceScale, RoundingMode.HALF_UP);
                billItem.setUnitPrice(newUnitPrice);
            } else {
                newQuantity = billItem.getAmountWithoutTax().divide(billItem.getUnitPrice(), 6, RoundingMode.HALF_UP);
                if (newQuantity.compareTo(BigDecimal.ZERO) == 0) {
                    newQuantity = DefaultSplitBillItemAmountServiceImpl.MIN_QUANTITY;
                }
                if (newQuantity.multiply(billItem.getUnitPrice()).setScale(2, RoundingMode.HALF_UP).compareTo(billItem.getAmountWithoutTax()) != 0) {
                    billItem.setUnitPrice(billItem.getAmountWithoutTax().divide(newQuantity, unitPriceScale, RoundingMode.HALF_UP));
                }
            }
            billItem.setQuantity(newQuantity);
        }
        if ((newAmount = billItem.getUnitPrice().multiply(billItem.getQuantity()).setScale(2, RoundingMode.HALF_UP)).compareTo(BigDecimal.ZERO) != 0 && this.gtErrorAmount(billItem, newAmount)) {
            throw new SplitBizException(String.format("\u65e0\u6cd5\u8ba1\u7b97\u660e\u7ec6id = [%s] \u540d\u79f0 [%s] \u7684\u5355\u4ef7\u4ee5\u53ca\u6570\u91cf, \u8bef\u5dee\u8d85\u8fc7\u4e00\u5206", billItem.getSalesbillItemId(), billItem.getItemName()));
        }
    }

    private boolean backCalculateQuantity(SplitRule rule, BillItem billItem) {
        return !AmountSplitRuleUtils.isQuantity(rule.getAmountSplitRule()) && billItem.getUnitPrice().compareTo(BigDecimal.ZERO) != 0;
    }

    private boolean backCalculateUnitPrice(SplitRule rule, BillItem billItem) {
        return AmountSplitRuleUtils.isQuantity(rule.getAmountSplitRule()) && billItem.getQuantity().compareTo(BigDecimal.ZERO) != 0;
    }

    private boolean backCalculateQuantityRounding(SplitRule rule, BillItem billItem) {
        return AmountSplitRuleUtils.recalculateQuantityRounding(rule.getAmountSplitRule()) && billItem.getUnitPrice().compareTo(BigDecimal.ZERO) != 0;
    }

    private boolean gtErrorAmount(BillItem billItem, BigDecimal amount) {
        return amount.subtract(billItem.getAmountWithoutTax()).abs().compareTo(new BigDecimal("0.01")) > 0;
    }
}

