/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service;

import com.google.common.collect.ImmutableSet;
import com.xforceplus.phoenix.split.constant.InvoiceItemOrder;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.PreInvoiceTemplateVersionStatus;
import com.xforceplus.phoenix.split.constant.RemarkConstant;
import com.xforceplus.phoenix.split.constant.SaleListOptionEnum;
import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.ItemTypeCodeEnum;
import com.xforceplus.phoenix.split.model.SplitRule;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class SplitRuleUtil {
    public static SplitGroupLimit createSplitGroupLimit(SplitRule rule, String goodsTaxNo, String itemTypeCode) {
        SplitGroupLimit splitGroupLimit = new SplitGroupLimit();
        splitGroupLimit.setLimitIsAmountWithTax(rule.isLimitIsAmountWithTax());
        splitGroupLimit.setInvoiceMaxErrorAmount(rule.getInvoiceMaxErrorAmount());
        splitGroupLimit.setLimitAmount(rule.getInvoiceLimit());
        splitGroupLimit.setInvoiceItemOrder(InvoiceItemOrder.fromValue(rule.getItemSort()));
        splitGroupLimit.setLimitLine(SplitRuleUtil.getLimitLine(rule, !RemarkConstant.HBBM_SET.contains(goodsTaxNo), itemTypeCode));
        return splitGroupLimit;
    }

    public static SplitGroupLimit createSplitGroupLimit(SplitRule rule, String itemTypeCode) {
        SplitGroupLimit splitGroupLimit = new SplitGroupLimit();
        splitGroupLimit.setLimitIsAmountWithTax(rule.isLimitIsAmountWithTax());
        splitGroupLimit.setInvoiceMaxErrorAmount(rule.getInvoiceMaxErrorAmount());
        splitGroupLimit.setLimitAmount(rule.getInvoiceLimit());
        splitGroupLimit.setInvoiceItemOrder(InvoiceItemOrder.fromValue(rule.getItemSort()));
        splitGroupLimit.setLimitLine(SplitRuleUtil.getLimitLine(rule, itemTypeCode));
        return splitGroupLimit;
    }

    public static SplitGroupLimit createSplitGroupLimit(SplitRule rule, String itemTypeCode, BillInfo billInfo, BillItem billItem) {
        BigDecimal invoiceLimit = billItem.isRedItem() && (StringUtils.isNotBlank((CharSequence)billInfo.getOriginInvoiceNo()) || StringUtils.isNotBlank((CharSequence)billInfo.getOriginInvoiceCode()) || StringUtils.isNotBlank((CharSequence)billInfo.getRedNotificationNo())) ? BigDecimal.valueOf(9.999999999999E10) : rule.getInvoiceLimit();
        SplitGroupLimit splitGroupLimit = new SplitGroupLimit();
        splitGroupLimit.setLimitIsAmountWithTax(rule.isLimitIsAmountWithTax());
        splitGroupLimit.setInvoiceMaxErrorAmount(rule.getInvoiceMaxErrorAmount());
        splitGroupLimit.setLimitAmount(invoiceLimit);
        splitGroupLimit.setInvoiceItemOrder(InvoiceItemOrder.fromValue(rule.getItemSort()));
        splitGroupLimit.setLimitLine(SplitRuleUtil.getLimitLine(rule, itemTypeCode));
        if (rule.isEnableAdvancedValidation()) {
            splitGroupLimit.setInvoiceMaxErrorAmount(BigDecimal.valueOf(1.27));
        }
        return splitGroupLimit;
    }

    public static int getLimitLine(SplitRule rule, boolean isCreateSalesList, String itemTypeCode) {
        if (!isCreateSalesList) {
            return rule.getInvoiceItemMaxRow();
        }
        if (SaleListOptionEnum.DISABLE_LIST_OPTION.getValue().equals(rule.getSaleListOption())) {
            return rule.getInvoiceItemMaxRow();
        }
        if (SaleListOptionEnum.ENABLE_LIST_OPTION.getValue().equals(rule.getSaleListOption())) {
            return Math.max(SplitRuleUtil.getSalesListMaxRow(rule), rule.getInvoiceItemMaxRow());
        }
        if (SaleListOptionEnum.FORCE_LIST_OPTION.getValue().equals(rule.getSaleListOption())) {
            return SplitRuleUtil.getSalesListMaxRow(rule);
        }
        throw new SplitBizException(String.format("value = [%s] for saleListOption is illegal", rule.getSaleListOption()));
    }

    public static int getLimitLine(SplitRule rule, String itemTypeCode) {
        if (ItemTypeCodeEnum.OIL.getValue().equals(itemTypeCode)) {
            return rule.getInvoiceItemMaxRow();
        }
        if (SaleListOptionEnum.DISABLE_LIST_OPTION.getValue().equals(rule.getSaleListOption())) {
            return rule.getInvoiceItemMaxRow();
        }
        if (SaleListOptionEnum.ENABLE_LIST_OPTION.getValue().equals(rule.getSaleListOption())) {
            return Math.max(SplitRuleUtil.getSalesListMaxRow(rule), rule.getInvoiceItemMaxRow());
        }
        if (SaleListOptionEnum.FORCE_LIST_OPTION.getValue().equals(rule.getSaleListOption())) {
            return SplitRuleUtil.getSalesListMaxRow(rule);
        }
        throw new SplitBizException(String.format("value = [%s] for saleListOption is illegal", rule.getSaleListOption()));
    }

    public static void validateSaleListOption(SplitRule rule) {
        if (!ImmutableSet.of((Object)SaleListOptionEnum.DISABLE_LIST_OPTION.getValue(), (Object)SaleListOptionEnum.ENABLE_LIST_OPTION.getValue(), (Object)SaleListOptionEnum.FORCE_LIST_OPTION.getValue()).contains((Object)rule.getSaleListOption())) {
            throw new SplitRuleParamException("\u9500\u8d27\u6e05\u5355\u53c2\u6570\u53ea\u80fd\u4e3a\uff1a0-\u4e0d\u542f\u52a8\u9500\u8d27\u6e05\u5355,1-\u542f\u52a8\u9500\u8d27\u6e05\u5355,2-\u5f3a\u5236\u542f\u7528\u9500\u8d27\u6e05\u5355");
        }
    }

    public static void validateInvoiceItemMaxRow(SplitRule rule) {
        Integer invoiceItemMaxRow = rule.getInvoiceItemMaxRow();
        if (invoiceItemMaxRow == null) {
            throw new SplitRuleParamException("\u53d1\u7968\u660e\u7ec6\u6700\u5927\u884c\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (invoiceItemMaxRow < 1) {
            throw new SplitRuleParamException("\u53d1\u7968\u660e\u7ec6\u6700\u5927\u884c\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        if (TaxInvoiceSourceEnum.SK.getValue().equals(rule.getTaxInvoiceSource()) && invoiceItemMaxRow > PreInvoiceTemplateVersionStatus.EIGHT.getValue()) {
            throw new SplitRuleParamException("\u53d1\u7968\u660e\u7ec6\u6700\u5927\u884c\u6570\u4e0d\u80fd\u8d85\u8fc78");
        }
    }

    public static void validateSalesListMaxRow(SplitRule rule) {
        if (SaleListOptionEnum.DISABLE_LIST_OPTION.getValue().equals(rule.getSaleListOption())) {
            return;
        }
        Integer salesListMaxRow = rule.getSalesListMaxRow();
        if (salesListMaxRow == null) {
            throw new SplitRuleParamException("\u542f\u7528\u9500\u8d27\u6e05\u5355\u65f6,\u5355\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (salesListMaxRow < 1) {
            throw new SplitRuleParamException("\u542f\u7528\u9500\u8d27\u6e05\u5355\u65f6\uff0c\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
    }

    public static int getSalesListMaxRow(SplitRule rule) {
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        Integer salesListMaxRow = rule.getSalesListMaxRow();
        if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource)) {
            return salesListMaxRow;
        }
        if (InvoiceType.ELECTRONIC.value().equals(rule.getInvoiceType()) && salesListMaxRow > 2000) {
            salesListMaxRow = 2000;
        } else if (salesListMaxRow > 2000) {
            salesListMaxRow = 2000;
        }
        return salesListMaxRow;
    }

    public static void validateUnitPriceAmountOps(SplitRule rule) {
        try {
            Byte.valueOf(rule.getUnitPriceAmountOps());
        }
        catch (Exception e) {
            throw new SplitRuleParamException("\u6253\u5370\u5355\u4ef7\u6570\u91cf\u89c4\u5219\u6709\u8bef");
        }
    }

    public static void validateSplitRule(SplitRule rule) {
        SplitRuleUtil.validateTaxInvoiceSource(rule);
        SplitRuleUtil.validateSaleListOption(rule);
        SplitRuleUtil.validateInvoiceItemMaxRow(rule);
        SplitRuleUtil.validateSalesListMaxRow(rule);
        SplitRuleUtil.validateUnitPriceAmountOps(rule);
        SplitRuleUtil.validateInvoiceLimit(rule);
    }

    public static void validateTaxInvoiceSource(SplitRule rule) {
        if (!ImmutableSet.of((Object)TaxInvoiceSourceEnum.SK.getValue(), (Object)TaxInvoiceSourceEnum.QD.getValue()).contains((Object)rule.getTaxInvoiceSource())) {
            throw new SplitRuleParamException("\u5e73\u53f0\u7c7b\u578b\u53c2\u6570\u53ea\u80fd\u4e3a\uff1ask-\u7a0e\u63a7\u5e73\u53f0\u7c7b\u578b,qd-\u5168\u7535\u5e73\u53f0\u7c7b\u578b");
        }
    }

    public static void validateInvoiceLimit(SplitRule rule) {
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        BigDecimal invoiceLimit = rule.getInvoiceLimit();
        if (invoiceLimit == null || invoiceLimit.compareTo(BigDecimal.ZERO) <= 0) {
            if (TaxInvoiceSourceEnum.SK.getValue().equals(taxInvoiceSource)) {
                throw new SplitRuleParamException("\u62c6\u7968\u9650\u989d\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e0");
            }
            rule.setInvoiceLimit(new BigDecimal("900000000.00"));
        }
    }

    public static BigDecimal getErrorTaxAmount(SplitRule splitRule, boolean isRedItem) {
        return SplitRuleUtil.getErrorTaxAmountNew(splitRule);
    }

    public static BigDecimal getErrorTaxAmountNew(SplitRule splitRule) {
        String taxInvoiceSource = splitRule.getTaxInvoiceSource();
        if (!StringUtils.equals((CharSequence)taxInvoiceSource, (CharSequence)TaxInvoiceSourceEnum.QD.getValue()) && !StringUtils.equals((CharSequence)taxInvoiceSource, (CharSequence)TaxInvoiceSourceEnum.SK.getValue())) {
            throw new SplitRuleParamException("\u627e\u4e0d\u5230\u8bef\u5dee\u914d\u7f6e");
        }
        boolean enableAdvancedValidation = splitRule.isEnableAdvancedValidation();
        if (enableAdvancedValidation) {
            return new BigDecimal("0.06");
        }
        return BigDecimal.valueOf(0.01);
    }
}

