/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.xforceplus.phoenix.split.constant.Tuple;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.BillItem;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class MinInvoiceService {
    private BigDecimal limitAmount;
    private boolean limitIsAmountWithTax;
    private int limitLine;
    private List<Integer> indexes;
    private int maxCount;
    private Multimap<Integer, InvoiceLimitState> state;

    protected MinInvoiceService(BigDecimal limitAmount, boolean limitIsAmountWithTax, int limitLine) {
        this.limitAmount = limitAmount;
        this.limitIsAmountWithTax = limitIsAmountWithTax;
        this.limitLine = limitLine;
    }

    public MinInvoiceService(SplitGroupLimit splitGroupLimit) {
        this(splitGroupLimit.getLimitAmount(), splitGroupLimit.isLimitIsAmountWithTax(), splitGroupLimit.getLimitLine());
    }

    public List<List<BillItem>> minMergeInvoices(List<ItemGroup> invoices) {
        List<List<BillItem>> invoiceList = new ArrayList<List<BillItem>>(invoices.size());
        for (ItemGroup itemGroup : invoices) {
            invoiceList.add(itemGroup.getBillItems());
        }
        ArrayList<List<BillItem>> result = new ArrayList<List<BillItem>>(invoiceList.size());
        while (invoiceList.size() > 1) {
            Tuple<List<BillItem>, List<List<BillItem>>> tuple = this.mergeInvoices(invoiceList);
            result.add(tuple.getFirst());
            invoiceList = tuple.getSecond();
        }
        if (invoiceList.size() == 1) {
            result.add((List<BillItem>)invoiceList.get(0));
        }
        return result;
    }

    private Tuple<List<BillItem>, List<List<BillItem>>> mergeInvoices(List<List<BillItem>> invoiceList) {
        this.maxCount = 0;
        this.indexes = new ArrayList<Integer>();
        this.state = HashMultimap.create();
        InvoiceLimitState invoiceLimitState = new InvoiceLimitState(this.limitAmount, this.limitIsAmountWithTax, this.limitLine);
        LinkedList<Integer> recordIndexes = new LinkedList<Integer>();
        this.exhaustiveInvoices(invoiceLimitState, 0, invoiceList, 0, recordIndexes);
        if (this.maxCount == 0) {
            throw new SplitBizException("\u6700\u5c11\u5f20\u6570\u53d1\u7968\u521b\u5efa\u5931\u8d25,\u8bf7\u8054\u7cfb\u4e2d\u53f0\u6392\u67e5");
        }
        HashSet<Integer> itemIndexesSet = new HashSet<Integer>(this.indexes);
        LinkedList invoice = new LinkedList();
        ArrayList<List<BillItem>> leftInvoice = new ArrayList<List<BillItem>>();
        for (int i = 0; i < invoiceList.size(); ++i) {
            if (itemIndexesSet.contains(i)) {
                invoice.addAll(invoiceList.get(i));
                continue;
            }
            leftInvoice.add(invoiceList.get(i));
        }
        return new Tuple<List<BillItem>, List<List<BillItem>>>(invoice, leftInvoice);
    }

    private void exhaustiveInvoices(InvoiceLimitState invoiceLimitState, int index, List<List<BillItem>> invoiceList, int count, List<Integer> recordIndexes) {
        if (index == invoiceList.size() || !invoiceLimitState.canAdd()) {
            if (count > this.maxCount) {
                this.maxCount = count;
                this.indexes.clear();
                this.indexes.addAll(recordIndexes);
            }
            recordIndexes.clear();
            return;
        }
        if (this.state.get((Object)index).contains(invoiceLimitState)) {
            return;
        }
        this.state.put((Object)index, (Object)invoiceLimitState);
        if (invoiceLimitState.canAddInvoice(invoiceList.get(index))) {
            InvoiceLimitState newInvoiceLimitState = invoiceLimitState.copy();
            newInvoiceLimitState.addInvoice(invoiceList.get(index));
            ArrayList<Integer> newRecordIndex = new ArrayList<Integer>(recordIndexes);
            newRecordIndex.add(index);
            this.exhaustiveInvoices(newInvoiceLimitState.copy(), index + 1, invoiceList, count + 1, newRecordIndex);
        }
        this.exhaustiveInvoices(invoiceLimitState.copy(), index + 1, invoiceList, count, new ArrayList<Integer>(recordIndexes));
    }

    public List<List<BillItem>> createMinInvoice(List<BillItem> toBeClassifiedBillItem) {
        if (CollectionUtils.isEmpty(toBeClassifiedBillItem)) {
            return Lists.newArrayList();
        }
        LinkedList<List<BillItem>> result = new LinkedList<List<BillItem>>();
        Iterator<BillItem> itemIterator = toBeClassifiedBillItem.iterator();
        while (itemIterator.hasNext()) {
            BillItem billItem = itemIterator.next();
            if (billItem.getDeductions().compareTo(BigDecimal.ZERO) <= 0) continue;
            ArrayList<BillItem> invoiceItem = new ArrayList<BillItem>();
            invoiceItem.add(billItem);
            result.add(invoiceItem);
            itemIterator.remove();
        }
        while (toBeClassifiedBillItem.size() > 1) {
            Tuple<List<BillItem>, List<BillItem>> tuple = this.createMaxItemInvoice(toBeClassifiedBillItem);
            result.add(tuple.getFirst());
            toBeClassifiedBillItem = tuple.getSecond();
        }
        if (toBeClassifiedBillItem.size() == 1) {
            result.add(Lists.newArrayList((Object[])new BillItem[]{toBeClassifiedBillItem.get(0)}));
            toBeClassifiedBillItem.clear();
        }
        return result;
    }

    private Tuple<List<BillItem>, List<BillItem>> createMaxItemInvoice(List<BillItem> toBeClassifiedBillItem) {
        this.maxCount = 0;
        this.indexes = new ArrayList<Integer>();
        this.state = HashMultimap.create();
        InvoiceLimitState invoiceLimitState = new InvoiceLimitState(this.limitAmount, this.limitIsAmountWithTax, this.limitLine);
        LinkedList<Integer> recordIndexes = new LinkedList<Integer>();
        this.exhaustiveItems(invoiceLimitState, 0, toBeClassifiedBillItem, 0, recordIndexes);
        if (this.maxCount == 0) {
            throw new SplitBizException("\u6700\u5c11\u5f20\u6570\u53d1\u7968\u521b\u5efa\u5931\u8d25,\u8bf7\u8054\u7cfb\u4e2d\u53f0\u6392\u67e5");
        }
        HashSet<Integer> itemIndexesSet = new HashSet<Integer>(this.indexes);
        LinkedList<BillItem> invoiceItems = new LinkedList<BillItem>();
        ArrayList<BillItem> leftItems = new ArrayList<BillItem>();
        for (int i = 0; i < toBeClassifiedBillItem.size(); ++i) {
            if (itemIndexesSet.contains(i)) {
                invoiceItems.add(toBeClassifiedBillItem.get(i));
                continue;
            }
            leftItems.add(toBeClassifiedBillItem.get(i));
        }
        return new Tuple<List<BillItem>, List<BillItem>>(invoiceItems, leftItems);
    }

    private void exhaustiveItems(InvoiceLimitState invoiceLimitState, int index, List<BillItem> toBeClassifiedBillItem, int itemCount, List<Integer> recordIndexes) {
        if (this.end(itemCount, index, invoiceLimitState, toBeClassifiedBillItem, recordIndexes)) {
            return;
        }
        if (this.state.get((Object)index).contains(invoiceLimitState)) {
            return;
        }
        this.state.put((Object)index, (Object)invoiceLimitState);
        if (invoiceLimitState.canAddItem(toBeClassifiedBillItem.get(index))) {
            InvoiceLimitState newInvoiceLimitState = invoiceLimitState.copy();
            newInvoiceLimitState.addItem(toBeClassifiedBillItem.get(index));
            ArrayList<Integer> newRecordIndex = new ArrayList<Integer>(recordIndexes);
            newRecordIndex.add(index);
            this.exhaustiveItems(newInvoiceLimitState.copy(), index + 1, toBeClassifiedBillItem, itemCount + 1, newRecordIndex);
        }
        this.exhaustiveItems(invoiceLimitState.copy(), index + 1, toBeClassifiedBillItem, itemCount, new ArrayList<Integer>(recordIndexes));
    }

    private <T> boolean end(int count, int index, InvoiceLimitState invoiceLimitState, List<T> data, List<Integer> recordIndexes) {
        if (index == data.size() || !invoiceLimitState.canAdd()) {
            if (count > this.maxCount) {
                this.maxCount = count;
                this.indexes.clear();
                this.indexes.addAll(recordIndexes);
            }
            recordIndexes.clear();
            return true;
        }
        return false;
    }

    private class InvoiceLimitState {
        private final BigDecimal ERROR_AMOUNT = new BigDecimal("1.27");
        private BigDecimal limitAmount;
        private boolean limitIsAmountWithTax;
        private int limitLine;
        private BigDecimal currentTotalAmount;
        private BigDecimal currentTotalError;
        private int currentLine;

        InvoiceLimitState(BigDecimal limitAmount, boolean limitIsAmountWithTax, int limitLine) {
            this.limitAmount = limitAmount;
            this.limitIsAmountWithTax = limitIsAmountWithTax;
            this.limitLine = limitLine;
            this.currentTotalAmount = BigDecimal.ZERO;
            this.currentTotalError = BigDecimal.ZERO;
            this.currentLine = 0;
        }

        InvoiceLimitState() {
        }

        boolean canAdd() {
            return this.currentTotalAmount.compareTo(this.limitAmount) <= 0 && this.currentLine < this.limitLine && this.currentTotalError.compareTo(this.ERROR_AMOUNT) <= 0;
        }

        boolean canAddItem(BillItem billItem) {
            BigDecimal amount = this.getBillItemAmount(billItem);
            BigDecimal errorAmount = this.getBillItemErrorAmount(billItem);
            int line = this.getBillItemLine(billItem);
            return this.currentTotalAmount.add(amount).compareTo(this.limitAmount) <= 0 && this.currentLine + line <= this.limitLine && this.currentTotalError.add(errorAmount).compareTo(this.ERROR_AMOUNT) <= 0;
        }

        void addItem(BillItem billItem) {
            BigDecimal amount = this.getBillItemAmount(billItem);
            BigDecimal errorAmount = this.getBillItemErrorAmount(billItem);
            int line = this.getBillItemLine(billItem);
            this.currentTotalAmount = this.currentTotalAmount.add(amount);
            this.currentLine += line;
            this.currentTotalError = this.currentTotalError.add(errorAmount);
        }

        boolean canAddInvoice(List<BillItem> billItems) {
            BigDecimal totalAmount = BigDecimal.ZERO;
            BigDecimal totalErrorAmount = BigDecimal.ZERO;
            int totalLine = 0;
            for (BillItem billItem : billItems) {
                BigDecimal amount = this.getBillItemAmount(billItem);
                BigDecimal errorAmount = this.getBillItemErrorAmount(billItem);
                int line = this.getBillItemLine(billItem);
                totalAmount = totalAmount.add(amount);
                totalErrorAmount = totalErrorAmount.add(errorAmount);
                if (this.currentTotalAmount.add(totalAmount).compareTo(this.limitAmount) <= 0 && this.currentLine + (totalLine += line) <= this.limitLine && this.currentTotalError.add(totalErrorAmount).compareTo(this.ERROR_AMOUNT) <= 0) continue;
                return false;
            }
            return true;
        }

        void addInvoice(List<BillItem> billItems) {
            billItems.forEach(this::addItem);
        }

        private int getBillItemLine(BillItem billItem) {
            if (billItem.getDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
                return 2;
            }
            return 1;
        }

        private BigDecimal getBillItemErrorAmount(BillItem billItem) {
            return billItem.getTaxAmount().subtract(billItem.getDiscountTax()).subtract(billItem.getAmountWithoutTax().subtract(billItem.getDiscountWithoutTax()).multiply(billItem.getTaxRate())).abs();
        }

        private BigDecimal getBillItemAmount(BillItem billItem) {
            BigDecimal result = this.limitIsAmountWithTax ? billItem.getAmountWithTax().subtract(billItem.getDiscountWithTax()) : billItem.getAmountWithoutTax().subtract(billItem.getDiscountWithoutTax());
            return result;
        }

        InvoiceLimitState copy() {
            InvoiceLimitState copy = new InvoiceLimitState();
            copy.currentTotalAmount = new BigDecimal(this.currentTotalAmount.toString());
            copy.currentTotalError = new BigDecimal(this.currentTotalError.toString());
            copy.currentLine = this.currentLine;
            copy.limitLine = this.limitLine;
            copy.limitAmount = this.limitAmount;
            copy.limitIsAmountWithTax = this.limitIsAmountWithTax;
            return copy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InvoiceLimitState that = (InvoiceLimitState)o;
            return this.currentLine == that.currentLine && this.currentTotalError.compareTo(that.currentTotalError) == 0 && this.currentTotalAmount.compareTo(that.currentTotalAmount) == 0;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.currentTotalAmount, this.currentTotalError, this.currentLine});
        }
    }
}

