/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class BillItemDiscountAmountProcessPlugin
implements DataProcessPlugin {
    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo) {
        itemGroups.forEach(itemGroup -> {
            List<BillItem> billItems = itemGroup.getBillItems();
            Map<String, List<BillItem>> groupIdBillItems = billItems.stream().filter(BillItem::isSplitItem).collect(Collectors.groupingBy(BillItem::getSalesbillItemId));
            groupIdBillItems.forEach((billItemId, billItems1) -> this.processDiscountAmount((List<BillItem>)billItems1));
        });
        return itemGroups;
    }

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo, TaxDeviceType taxDeviceType) {
        return this.processData(itemGroups, billInfo, ruleInfo);
    }

    private void processDiscountAmount(List<BillItem> billItems) {
        BillItem lastBillItem = billItems.get(billItems.size() - 1);
        BigDecimal amountWithoutTaxAndDiscount = lastBillItem.getOriginalAmountWithoutTax().subtract(lastBillItem.getInnerDiscountWithoutTax()).subtract(lastBillItem.getInnerPrepayAmountWithoutTax());
        BigDecimal outterDiscountAmount = lastBillItem.getOutterDiscountWithoutTax().add(lastBillItem.getOutterPrepayAmountWithoutTax());
        DiscountAmountInfo discountAmountInfo = new DiscountAmountInfo();
        BigDecimal innerDiscountWithoutTax = BigDecimal.ZERO;
        BigDecimal innerPrepayAmountWithoutTax = BigDecimal.ZERO;
        for (int i = 0; i < billItems.size() - 1; ++i) {
            BillItem billItem = billItems.get(i);
            BigDecimal rate = billItem.getAmountWithoutTax().divide(amountWithoutTaxAndDiscount, 10, 1);
            if (billItem.getInnerDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
                innerDiscountWithoutTax = this.calculateAmountByRate(rate, billItem.getInnerDiscountWithoutTax());
            }
            if (billItem.getInnerPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
                innerPrepayAmountWithoutTax = this.calculateAmountByRate(rate, billItem.getInnerPrepayAmountWithoutTax());
            }
            if (outterDiscountAmount.compareTo(BigDecimal.ZERO) > 0) {
                rate = billItem.getOutterDiscountWithoutTax().divide(outterDiscountAmount, 10, 1);
            }
            this.processItemDiscountAmount(discountAmountInfo, billItem, innerDiscountWithoutTax, innerPrepayAmountWithoutTax, rate);
        }
        lastBillItem.setInnerDiscountWithoutTax(lastBillItem.getInnerDiscountWithoutTax().subtract(discountAmountInfo.getInnerDiscountWithoutTax()));
        lastBillItem.setInnerDiscountTax(lastBillItem.getInnerDiscountTax().subtract(discountAmountInfo.getInnerDiscountTax()));
        lastBillItem.setInnerDiscountWithTax(lastBillItem.getInnerDiscountWithTax().subtract(discountAmountInfo.getInnerDiscountWithTax()));
        lastBillItem.setInnerPrepayAmountWithoutTax(lastBillItem.getInnerPrepayAmountWithoutTax().subtract(discountAmountInfo.getInnerPrepayAmountWithoutTax()));
        lastBillItem.setInnerPrepayAmountTax(lastBillItem.getInnerPrepayAmountTax().subtract(discountAmountInfo.getInnerPrepayAmountTax()));
        lastBillItem.setInnerPrepayAmountWithTax(lastBillItem.getInnerPrepayAmountWithTax().subtract(discountAmountInfo.getInnerPrepayAmountWithTax()));
        lastBillItem.setOutterDiscountWithoutTax(lastBillItem.getOutterDiscountWithoutTax().subtract(discountAmountInfo.getOutterDiscountWithoutTax()));
        lastBillItem.setOutterDiscountTax(lastBillItem.getOutterDiscountTax().subtract(discountAmountInfo.getOutterDiscountTax()));
        lastBillItem.setOutterDiscountWithTax(lastBillItem.getOutterDiscountWithTax().subtract(discountAmountInfo.getOutterDiscountWithTax()));
        lastBillItem.setOutterPrepayAmountWithoutTax(lastBillItem.getOutterPrepayAmountWithoutTax().subtract(discountAmountInfo.getOutterPrepayAmountWithoutTax()));
        lastBillItem.setOutterPrepayAmountTax(lastBillItem.getOutterPrepayAmountTax().subtract(discountAmountInfo.getOutterPrepayAmountTax()));
        lastBillItem.setOutterPrepayAmountWithTax(lastBillItem.getOutterPrepayAmountWithTax().subtract(discountAmountInfo.getOutterPrepayAmountWithTax()));
    }

    private void processItemDiscountAmount(DiscountAmountInfo discountAmountInfo, BillItem billItem, BigDecimal innerDiscountWithoutTax, BigDecimal innerPrepayAmountWithoutTax, BigDecimal outDiscountrate) {
        BigDecimal rateTax = billItem.getTaxRate();
        BigDecimal innerDiscountTax = this.calculateTaxAmount(innerDiscountWithoutTax, rateTax);
        BigDecimal innerDiscountWithTax = this.calculateAmountWithTax(innerDiscountWithoutTax, innerDiscountTax);
        billItem.setInnerDiscountWithoutTax(innerDiscountWithoutTax);
        billItem.setInnerDiscountTax(innerDiscountTax);
        billItem.setInnerDiscountWithTax(innerDiscountWithTax);
        discountAmountInfo.setInnerDiscountWithoutTax(discountAmountInfo.getInnerDiscountWithoutTax().add(innerDiscountWithoutTax));
        discountAmountInfo.setInnerDiscountTax(discountAmountInfo.getInnerDiscountTax().add(innerDiscountTax));
        discountAmountInfo.setInnerDiscountWithTax(discountAmountInfo.getInnerDiscountWithTax().add(innerDiscountWithTax));
        BigDecimal innerPrepayAmountTax = this.calculateTaxAmount(innerPrepayAmountWithoutTax, rateTax);
        BigDecimal innerPrepayAmountWithTax = this.calculateAmountWithTax(innerPrepayAmountWithoutTax, innerPrepayAmountTax);
        billItem.setInnerPrepayAmountWithoutTax(innerPrepayAmountWithoutTax);
        billItem.setInnerPrepayAmountTax(innerPrepayAmountTax);
        billItem.setInnerPrepayAmountWithTax(innerPrepayAmountWithTax);
        discountAmountInfo.setInnerPrepayAmountWithoutTax(discountAmountInfo.getInnerPrepayAmountWithoutTax().add(innerPrepayAmountWithoutTax));
        discountAmountInfo.setInnerPrepayAmountTax(discountAmountInfo.getInnerPrepayAmountTax().add(innerPrepayAmountTax));
        discountAmountInfo.setInnerPrepayAmountWithTax(discountAmountInfo.getInnerPrepayAmountWithTax().add(innerPrepayAmountWithTax));
        BigDecimal outterDiscountWithoutTax = this.calculateAmountByRate(outDiscountrate, billItem.getDiscountWithoutTax());
        BigDecimal outterDiscountTax = this.calculateAmountByRate(outDiscountrate, billItem.getDiscountTax());
        BigDecimal outterDiscountWithTax = this.calculateAmountByRate(outDiscountrate, billItem.getDiscountWithTax());
        BigDecimal outterPrepayAmountWithoutTax = billItem.getDiscountWithoutTax().subtract(outterDiscountWithoutTax);
        BigDecimal outterPrepayAmountTax = billItem.getDiscountTax().subtract(outterDiscountTax);
        BigDecimal outterPrepayAmountWithTax = billItem.getDiscountWithTax().subtract(outterDiscountWithTax);
        billItem.setOutterDiscountWithoutTax(outterDiscountWithoutTax);
        billItem.setOutterDiscountTax(outterDiscountTax);
        billItem.setOutterDiscountWithTax(outterDiscountWithTax);
        discountAmountInfo.setOutterDiscountWithoutTax(discountAmountInfo.getOutterDiscountWithoutTax().add(outterDiscountWithoutTax));
        discountAmountInfo.setOutterDiscountTax(discountAmountInfo.getOutterDiscountTax().add(outterDiscountTax));
        discountAmountInfo.setOutterDiscountWithTax(discountAmountInfo.getOutterDiscountWithTax().add(outterDiscountWithTax));
        billItem.setOutterPrepayAmountWithoutTax(outterPrepayAmountWithoutTax);
        billItem.setOutterPrepayAmountTax(outterPrepayAmountTax);
        billItem.setOutterPrepayAmountWithTax(outterPrepayAmountWithTax);
        discountAmountInfo.setOutterPrepayAmountWithoutTax(discountAmountInfo.getOutterPrepayAmountWithoutTax().add(outterPrepayAmountWithoutTax));
        discountAmountInfo.setOutterPrepayAmountTax(discountAmountInfo.getOutterPrepayAmountTax().add(outterPrepayAmountTax));
        discountAmountInfo.setOutterPrepayAmountWithTax(discountAmountInfo.getOutterPrepayAmountWithTax().add(outterPrepayAmountWithTax));
    }

    private BigDecimal calculateAmountWithTax(BigDecimal amountWithoutTax, BigDecimal amountTax) {
        return amountWithoutTax.add(amountTax);
    }

    private BigDecimal calculateTaxAmount(BigDecimal amountWithoutTax, BigDecimal rateTax) {
        return amountWithoutTax.multiply(rateTax).setScale(2, 4);
    }

    private BigDecimal calculateAmountByRate(BigDecimal rate, BigDecimal totalAmountWithoutTax) {
        return rate.multiply(totalAmountWithoutTax).setScale(2, 4);
    }

    private class DiscountAmountInfo {
        private BigDecimal outterDiscountWithTax = BigDecimal.ZERO;
        private BigDecimal outterDiscountWithoutTax = BigDecimal.ZERO;
        private BigDecimal outterDiscountTax = BigDecimal.ZERO;
        private BigDecimal innerDiscountWithTax = BigDecimal.ZERO;
        private BigDecimal innerDiscountWithoutTax = BigDecimal.ZERO;
        private BigDecimal innerDiscountTax = BigDecimal.ZERO;
        private BigDecimal outterPrepayAmountWithTax = BigDecimal.ZERO;
        private BigDecimal outterPrepayAmountWithoutTax = BigDecimal.ZERO;
        private BigDecimal outterPrepayAmountTax = BigDecimal.ZERO;
        private BigDecimal innerPrepayAmountWithTax = BigDecimal.ZERO;
        private BigDecimal innerPrepayAmountWithoutTax = BigDecimal.ZERO;
        private BigDecimal innerPrepayAmountTax = BigDecimal.ZERO;

        private DiscountAmountInfo() {
        }

        public BigDecimal getOutterDiscountWithTax() {
            return this.outterDiscountWithTax;
        }

        public BigDecimal getOutterDiscountWithoutTax() {
            return this.outterDiscountWithoutTax;
        }

        public BigDecimal getOutterDiscountTax() {
            return this.outterDiscountTax;
        }

        public BigDecimal getInnerDiscountWithTax() {
            return this.innerDiscountWithTax;
        }

        public BigDecimal getInnerDiscountWithoutTax() {
            return this.innerDiscountWithoutTax;
        }

        public BigDecimal getInnerDiscountTax() {
            return this.innerDiscountTax;
        }

        public BigDecimal getOutterPrepayAmountWithTax() {
            return this.outterPrepayAmountWithTax;
        }

        public BigDecimal getOutterPrepayAmountWithoutTax() {
            return this.outterPrepayAmountWithoutTax;
        }

        public BigDecimal getOutterPrepayAmountTax() {
            return this.outterPrepayAmountTax;
        }

        public BigDecimal getInnerPrepayAmountWithTax() {
            return this.innerPrepayAmountWithTax;
        }

        public BigDecimal getInnerPrepayAmountWithoutTax() {
            return this.innerPrepayAmountWithoutTax;
        }

        public BigDecimal getInnerPrepayAmountTax() {
            return this.innerPrepayAmountTax;
        }

        public void setOutterDiscountWithTax(BigDecimal outterDiscountWithTax) {
            this.outterDiscountWithTax = outterDiscountWithTax;
        }

        public void setOutterDiscountWithoutTax(BigDecimal outterDiscountWithoutTax) {
            this.outterDiscountWithoutTax = outterDiscountWithoutTax;
        }

        public void setOutterDiscountTax(BigDecimal outterDiscountTax) {
            this.outterDiscountTax = outterDiscountTax;
        }

        public void setInnerDiscountWithTax(BigDecimal innerDiscountWithTax) {
            this.innerDiscountWithTax = innerDiscountWithTax;
        }

        public void setInnerDiscountWithoutTax(BigDecimal innerDiscountWithoutTax) {
            this.innerDiscountWithoutTax = innerDiscountWithoutTax;
        }

        public void setInnerDiscountTax(BigDecimal innerDiscountTax) {
            this.innerDiscountTax = innerDiscountTax;
        }

        public void setOutterPrepayAmountWithTax(BigDecimal outterPrepayAmountWithTax) {
            this.outterPrepayAmountWithTax = outterPrepayAmountWithTax;
        }

        public void setOutterPrepayAmountWithoutTax(BigDecimal outterPrepayAmountWithoutTax) {
            this.outterPrepayAmountWithoutTax = outterPrepayAmountWithoutTax;
        }

        public void setOutterPrepayAmountTax(BigDecimal outterPrepayAmountTax) {
            this.outterPrepayAmountTax = outterPrepayAmountTax;
        }

        public void setInnerPrepayAmountWithTax(BigDecimal innerPrepayAmountWithTax) {
            this.innerPrepayAmountWithTax = innerPrepayAmountWithTax;
        }

        public void setInnerPrepayAmountWithoutTax(BigDecimal innerPrepayAmountWithoutTax) {
            this.innerPrepayAmountWithoutTax = innerPrepayAmountWithoutTax;
        }

        public void setInnerPrepayAmountTax(BigDecimal innerPrepayAmountTax) {
            this.innerPrepayAmountTax = innerPrepayAmountTax;
        }
    }
}

