/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.AbstractBillItemGroupPlugin;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GroupItemByTaxPreConPlugin
extends AbstractBillItemGroupPlugin {
    @Override
    protected String generateKey(BillItem billItem, SplitRule rule) {
        return "\u4e0d\u5f81\u7a0e".equals(billItem.getTaxPreCon()) ? "no_taxation" : "else_zero_tax";
    }

    @Override
    protected boolean support(SplitRule rule, List<ItemGroup> itemGroups) {
        String taxInvoiceSource = rule.getTaxInvoiceSource();
        if (TaxInvoiceSourceEnum.QD.getValue().equals(taxInvoiceSource)) {
            return itemGroups.stream().anyMatch(e -> {
                List<BillItem> billItems = e.getBillItems();
                return !CollectionUtils.isEmpty(billItems) && billItems.stream().filter(billItem -> StringUtils.isNotBlank((CharSequence)billItem.getTaxPreCon())).anyMatch(billItem -> billItem.getTaxPreCon().equals("\u4e0d\u5f81\u7a0e"));
            });
        }
        return false;
    }
}

