/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.constant.InvoiceItemOrder;
import com.xforceplus.phoenix.split.constant.RemarkConstant;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.SplitBillItemAmountService;
import com.xforceplus.phoenix.split.service.SplitRuleUtil;
import com.xforceplus.phoenix.split.service.dataflow.impl.SplitBillItemPlugin;
import com.xforceplus.phoenix.split.util.ThreadLocalFactory;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class MinSplitBillItemPlugin
extends SplitBillItemPlugin {
    @Autowired
    @Qualifier(value="minInvoiceSplitItemServiceImpl")
    private SplitBillItemAmountService splitBillItemAmountService;
    private static final BigDecimal MIN_BALANCE_LIMIT = new BigDecimal("0.99");

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo, TaxDeviceType taxDeviceType) {
        SplitRule rule = ruleInfo.getSplitRule();
        if (!InvoiceItemOrder.ITEM_NO_MINIMUM_INVOICES.value().equals(rule.getItemSort())) {
            return itemGroups;
        }
        itemGroups.forEach(itemGroup -> {
            LinkedList<BillItem> billItemList = new LinkedList<BillItem>();
            String itemTypeCode = itemGroup.getBillItems().get(0).getItemTypeCode();
            BigDecimal invoiceRestLimitAmount = this.resetInvoiceLimitAmount(rule);
            int lineLimitNum = this.resetLineLimitNum(rule, itemTypeCode);
            for (BillItem billItem : itemGroup.getBillItems()) {
                this.checkPriceAndQuantity(billItem);
                this.mergeDiscountWithoutTax(billItem);
                if (this.exceedLineLimit(billItem, lineLimitNum)) {
                    lineLimitNum = this.resetLineLimitNum(rule, itemTypeCode);
                    invoiceRestLimitAmount = this.resetInvoiceLimitAmount(rule);
                }
                if (this.exceedInvoiceAmountLimit(billItem, invoiceRestLimitAmount)) {
                    List<BillItem> billItems = this.splitCurrentItem(billItem, rule, invoiceRestLimitAmount);
                    BillItem lastSplitItem = billItems.get(billItems.size() - 1);
                    invoiceRestLimitAmount = rule.getInvoiceLimit().subtract(this.getActualAmount(lastSplitItem));
                    lineLimitNum -= this.needLineNum(billItem);
                    billItemList.addAll(billItems);
                } else {
                    invoiceRestLimitAmount = invoiceRestLimitAmount.subtract(this.getActualAmount(billItem));
                    lineLimitNum -= this.needLineNum(billItem);
                    billItemList.add(billItem);
                }
                if (!this.isInvoiceAmountSaturated(invoiceRestLimitAmount)) continue;
                invoiceRestLimitAmount = this.resetInvoiceLimitAmount(rule);
                lineLimitNum = this.resetLineLimitNum(rule, itemTypeCode);
            }
            itemGroup.setBillItems(billItemList);
        });
        return itemGroups;
    }

    private void mergeDiscountWithoutTax(BillItem billItem) {
        billItem.setDiscountWithoutTax(billItem.getOutterDiscountWithoutTax().add(billItem.getOutterPrepayAmountWithoutTax()).add(billItem.getInnerDiscountWithoutTax().add(billItem.getInnerPrepayAmountWithoutTax())));
    }

    private List<BillItem> splitCurrentItem(BillItem billItem, SplitRule rule, BigDecimal balanceInvoiceAmount) {
        ThreadLocalFactory.initThreadLocal(billItem);
        ItemAmountInfo itemAmountInfo = this.copyBillItemAmountInfo(billItem, rule);
        itemAmountInfo.setBalanceInvoiceAmount(balanceInvoiceAmount);
        List<ItemAmountInfo> itemAmountInfoList = this.splitBillItemAmountService.splitAmount(itemAmountInfo, rule);
        ThreadLocalFactory.clearContext();
        this.logger.debug("split id = {} itemAmount, result = {}", (Object)billItem.getSalesbillItemId(), itemAmountInfoList);
        return this.reCreateBillItem(itemAmountInfoList, billItem);
    }

    private boolean isInvoiceAmountSaturated(BigDecimal invoiceRestAmount) {
        return MIN_BALANCE_LIMIT.compareTo(invoiceRestAmount) > 0;
    }

    private BigDecimal getActualAmount(BillItem billItem) {
        return billItem.getAmountWithoutTax().subtract(billItem.getDiscountWithoutTax());
    }

    private boolean exceedInvoiceAmountLimit(BillItem billItem, BigDecimal invoiceRestAmount) {
        BigDecimal discount;
        BigDecimal amountWithoutTax = billItem.getAmountWithoutTax();
        return amountWithoutTax.subtract(discount = billItem.getInnerDiscountWithoutTax().add(billItem.getInnerPrepayAmountWithoutTax()).add(billItem.getOutterDiscountWithoutTax()).add(billItem.getOutterPrepayAmountWithoutTax())).compareTo(invoiceRestAmount) > 0;
    }

    private boolean exceedLineLimit(BillItem billItem, int lineNum) {
        int needLineNum = this.needLineNum(billItem);
        return needLineNum > lineNum;
    }

    private int resetLineLimitNum(SplitRule rule, String goodsTaxNo, String itemTypeCode) {
        return SplitRuleUtil.getLimitLine(rule, !RemarkConstant.HBBM_SET.contains(goodsTaxNo), itemTypeCode);
    }

    private int resetLineLimitNum(SplitRule rule, String itemTypeCode) {
        return SplitRuleUtil.getLimitLine(rule, itemTypeCode);
    }

    private BigDecimal resetInvoiceLimitAmount(SplitRule rule) {
        return rule.getInvoiceLimit();
    }
}

