/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl.invoiceLimit;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.config.SplitProperties;
import com.xforceplus.phoenix.split.constant.TaxDeviceType;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.impl.invoiceLimit.AbstractCombineItemService;
import com.xforceplus.phoenix.split.service.dataflow.impl.invoiceLimit.CombineItemService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class ItemOrderCombineItemService
extends AbstractCombineItemService
implements CombineItemService {
    public ItemOrderCombineItemService(SplitProperties splitProperties) {
        super(splitProperties);
    }

    @Override
    public List<BillItem> combineItem(List<BillItem> billItems, SplitGroupLimit splitGroupLimit, TaxDeviceType taxDeviceType, SplitRule splitRule) {
        BigDecimal amount = BigDecimal.ZERO;
        int lineNum = 0;
        BigDecimal quantity = BigDecimal.ZERO;
        BigDecimal totalErrorAmount = BigDecimal.ZERO;
        BigDecimal totalErrorAmountAbs = BigDecimal.ZERO;
        BigDecimal basicInvoiceMaxErrorAmount = this.getMaxErrorAmountByTaxDeviceType(taxDeviceType, splitRule);
        BigDecimal businessInvoiceMaxErrorAmount = splitGroupLimit.getInvoiceMaxErrorAmount();
        LinkedList splitGroup = Lists.newLinkedList();
        Iterator<BillItem> it = billItems.iterator();
        while (it.hasNext()) {
            BillItem item = it.next();
            if (item.getDeductions().compareTo(BigDecimal.ZERO) > 0) {
                if (CollectionUtils.isNotEmpty((Collection)splitGroup)) continue;
                splitGroup.add(item);
                it.remove();
                return splitGroup;
            }
            boolean isAmountGtLimit = amount.add(super.actualAmount(item, splitGroupLimit.isLimitIsAmountWithTax())).compareTo(splitGroupLimit.getLimitAmount()) > 0;
            boolean isLineGtLimit = lineNum + this.actualLineNum(item) > splitGroupLimit.getLimitLine();
            boolean isQuantityGtLimit = Objects.nonNull(splitGroupLimit.getLimitQuantity()) && quantity.add(item.getQuantity()).compareTo(splitGroupLimit.getLimitQuantity()) > 0;
            BigDecimal currentItemErrorAmount = this.errorAmountCalculation(item, taxDeviceType);
            BigDecimal currentItemErrorAmountAbs = this.errorAmountCalculation(item, TaxDeviceType.HX_SINGL);
            boolean rateFor1dot27 = this.totalErrorAmountCalculation(totalErrorAmount, currentItemErrorAmount, basicInvoiceMaxErrorAmount, taxDeviceType);
            boolean rateForBusinessRule = this.totalErrorAmountCalculationForBusiness(totalErrorAmountAbs, currentItemErrorAmountAbs, businessInvoiceMaxErrorAmount);
            if (isAmountGtLimit || isQuantityGtLimit || isLineGtLimit || rateFor1dot27 || rateForBusinessRule) {
                return splitGroup;
            }
            amount = amount.add(super.actualAmount(item, splitGroupLimit.isLimitIsAmountWithTax()));
            lineNum += this.actualLineNum(item);
            quantity = Objects.nonNull(splitGroupLimit.getLimitQuantity()) ? quantity.add(item.getQuantity()) : BigDecimal.ZERO;
            totalErrorAmount = totalErrorAmount.add(currentItemErrorAmount);
            totalErrorAmountAbs = totalErrorAmountAbs.add(currentItemErrorAmountAbs);
            splitGroup.add(item);
            it.remove();
        }
        return splitGroup;
    }
}

