/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.AmountSplitRuleUtils;
import com.xforceplus.phoenix.split.service.SplitRuleUtil;
import com.xforceplus.phoenix.split.util.ThreadLocalFactory;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import org.springframework.util.CollectionUtils;

public abstract class AbstractSplitBillItemAmountService {
    private static final BigDecimal MIN_QUANTITY = BigDecimal.ONE.movePointLeft(6);
    private static final BigDecimal refer = new BigDecimal("0.01");

    protected void mergeDiscountAmount(ItemAmountInfo itemAmountInfo) {
        itemAmountInfo.setAmountWithoutTax(itemAmountInfo.getAmountWithoutTax().subtract(itemAmountInfo.getInnerDiscountWithoutTax()).subtract(itemAmountInfo.getInnerPrepayAmountWithoutTax()));
        itemAmountInfo.setAmountWithTax(itemAmountInfo.getAmountWithTax().subtract(itemAmountInfo.getInnerDiscountWithTax()).subtract(itemAmountInfo.getInnerPrepayAmountWithTax()));
        itemAmountInfo.setTaxAmount(itemAmountInfo.getTaxAmount().subtract(itemAmountInfo.getInnerDiscountTax()).subtract(itemAmountInfo.getInnerPrepayAmountTax()));
        itemAmountInfo.setDiscountWithoutTax(itemAmountInfo.getOutterDiscountWithoutTax().add(itemAmountInfo.getOutterPrepayAmountWithoutTax()));
        itemAmountInfo.setDiscountWithTax(itemAmountInfo.getOutterDiscountWithTax().add(itemAmountInfo.getOutterPrepayAmountWithTax()));
        itemAmountInfo.setDiscountTax(itemAmountInfo.getOutterDiscountTax().add(itemAmountInfo.getOutterPrepayAmountTax()));
    }

    protected void deductSplitItemAmount(SplitRule rule, ItemAmountInfo itemAmountInfo, ItemAmountInfo splitItemAmountInfo) {
        itemAmountInfo.deductNewItemAmount(splitItemAmountInfo);
        if (AmountSplitRuleUtils.isUnitPriceAndQuantityInteger(rule.getAmountSplitRule()) || AmountSplitRuleUtils.recalculateQuantityRounding(rule.getAmountSplitRule()) || AmountSplitRuleUtils.isUnitPrice(rule.getAmountSplitRule()) || AmountSplitRuleUtils.isUnitPriceAndRecalculateQuantity(rule.getAmountSplitRule())) {
            itemAmountInfo.setQuantity(itemAmountInfo.getQuantity().subtract(splitItemAmountInfo.getQuantity()));
        }
    }

    protected void processLastItemUnitPriceAndQuantity(ItemAmountInfo itemAmountInfo, boolean hasQuantity, SplitRule rule) {
        if (!hasQuantity) {
            return;
        }
        BigDecimal quantity = itemAmountInfo.getQuantity();
        BigDecimal price = itemAmountInfo.getUnitPrice();
        if (quantity.compareTo(BigDecimal.ZERO) == 0) {
            quantity = MIN_QUANTITY;
        }
        if (this.checkAmount(quantity, price, itemAmountInfo.getAmountWithoutTax()).booleanValue()) {
            return;
        }
        if (AmountSplitRuleUtils.isUnitPriceAndRecalculateQuantity(rule.getAmountSplitRule())) {
            quantity = itemAmountInfo.getAmountWithoutTax().divide(price, 6, RoundingMode.DOWN);
            if (this.checkAmount(quantity, price, itemAmountInfo.getAmountWithoutTax()).booleanValue()) {
                itemAmountInfo.setQuantity(quantity);
                return;
            }
            quantity = itemAmountInfo.getAmountWithoutTax().divide(price, 6, RoundingMode.UP);
            if (this.checkAmount(quantity, price, itemAmountInfo.getAmountWithoutTax()).booleanValue()) {
                itemAmountInfo.setQuantity(quantity);
                return;
            }
        }
        itemAmountInfo.setUnitPrice(itemAmountInfo.getAmountWithoutTax().divide(quantity, (int)rule.getUnitPriceScale(), RoundingMode.HALF_UP));
    }

    protected Boolean checkAmount(BigDecimal quantity, BigDecimal price, BigDecimal amountWithOutTax) {
        BigDecimal currentAmount = quantity.multiply(price).setScale(3, RoundingMode.HALF_UP);
        if (amountWithOutTax.subtract(currentAmount).abs().compareTo(refer) < 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected List<ItemAmountInfo> processLastItemErrorAmount(ItemAmountInfo originalItem, List<ItemAmountInfo> result, SplitRule rule) {
        if (originalItem == null) {
            return result;
        }
        BigDecimal taxAmount = originalItem.getTaxAmount();
        BigDecimal expectedTaxAmount = originalItem.getAmountWithoutTax().subtract(originalItem.getDeductions()).multiply(originalItem.getTaxRate());
        BigDecimal errorAmount = taxAmount.subtract(expectedTaxAmount);
        ItemAmountInfo discountItem = this.findEffectiveDiscountItem(originalItem, result);
        BigDecimal discountTax = discountItem.getDiscountTax();
        BigDecimal expectedDiscountTax = discountItem.getDiscountWithoutTax().multiply(discountItem.getTaxRate());
        BigDecimal errorDiscountTax = discountTax.subtract(expectedDiscountTax);
        BillItem billItem = this.getBillItemFromThreadLocal();
        BigDecimal offsetAmount = SplitRuleUtil.getErrorTaxAmount(rule, billItem.isRedItem());
        if (errorAmount.abs().compareTo(offsetAmount) <= 0 && errorDiscountTax.abs().compareTo(offsetAmount) <= 0) {
            result.add((ItemAmountInfo)originalItem);
            return result;
        }
        if (errorAmount.abs().compareTo(offsetAmount) > 0) {
            this.doAdjustNew(originalItem, errorAmount, offsetAmount, result, (x, y) -> {
                x.setTaxAmount(x.getTaxAmount().add((BigDecimal)y));
                x.setAmountWithTax(x.getTaxAmount().add(x.getAmountWithoutTax()));
            }, (x, y) -> {
                x.setTaxAmount(x.getTaxAmount().add((BigDecimal)y));
                x.setAmountWithTax(x.getAmountWithoutTax().add(x.getTaxAmount()));
            });
        }
        if (errorDiscountTax.abs().compareTo(offsetAmount) > 0) {
            result = Lists.reverse(result);
            this.doAdjustNew(discountItem, errorDiscountTax, offsetAmount, result, (x, y) -> {
                x.setDiscountTax(x.getDiscountTax().add((BigDecimal)y));
                x.setDiscountWithTax(x.getDiscountTax().add(x.getDiscountWithoutTax()));
            }, (x, y) -> {
                x.setDiscountTax(x.getDiscountTax().add((BigDecimal)y));
                x.setDiscountWithTax(x.getDiscountWithoutTax().add(x.getDiscountTax()));
            });
        }
        result.add(originalItem);
        return result;
    }

    protected BillItem getBillItemFromThreadLocal() {
        ThreadLocal<Object> threadLocal = ThreadLocalFactory.fetchThreadLocal();
        Object object = threadLocal.get();
        BillItem threadLocalItem = object == null ? new BillItem() : (BillItem)object;
        return (BillItem)JSON.parseObject((String)JSON.toJSONString((Object)threadLocalItem), BillItem.class);
    }

    protected ItemAmountInfo findEffectiveDiscountItem(ItemAmountInfo originalItem, List<ItemAmountInfo> result) {
        BigDecimal discountTax = originalItem.getDiscountTax();
        if (BigDecimal.ZERO.compareTo(discountTax) == 0) {
            for (int i = result.size() - 1; i >= 0; --i) {
                ItemAmountInfo item = result.get(i);
                if (item.getDiscountTax().compareTo(BigDecimal.ZERO) == 0) continue;
                return item;
            }
            return originalItem;
        }
        return originalItem;
    }

    private List<ItemAmountInfo> doAdjustNew(ItemAmountInfo splitAmountInfo, BigDecimal errorAmount, BigDecimal offsetAmount, List<ItemAmountInfo> result, BiConsumer<ItemAmountInfo, BigDecimal> consumer, BiConsumer<ItemAmountInfo, BigDecimal> consumer2) {
        BigDecimal remainder;
        int adjustNum;
        if (errorAmount.abs().compareTo(offsetAmount) > 0) {
            BigDecimal divideResult = errorAmount.divide(offsetAmount, 4);
            adjustNum = divideResult.setScale(0, RoundingMode.DOWN).abs().intValue();
            remainder = errorAmount.abs().subtract(offsetAmount.abs().multiply(BigDecimal.valueOf(adjustNum))).setScale(2, RoundingMode.DOWN);
            if (remainder.signum() > 0) {
                ++adjustNum;
            }
        } else {
            adjustNum = 1;
            remainder = errorAmount.abs();
        }
        Object[] array = new BigDecimal[adjustNum];
        Arrays.fill(array, offsetAmount);
        if (remainder.signum() > 0) {
            array[adjustNum - 1] = remainder;
        }
        if (!CollectionUtils.isEmpty(result) && adjustNum > result.size()) {
            ThreadLocal<Object> threadLocal = ThreadLocalFactory.fetchThreadLocal();
            Object object = threadLocal.get();
            BillItem threadLocalItem = object == null ? new BillItem() : (BillItem)object;
            BillItem billItem = (BillItem)JSON.parseObject((String)JSON.toJSONString((Object)threadLocalItem), BillItem.class);
            threadLocal.remove();
            throw new SplitBizException(String.format("\u660e\u7ec6id = [%s]  \u540d\u79f0 [%s] \u4e0d\u542b\u7a0e\u91d1\u989d[%s]*\u7a0e\u7387[%s] \u4e0e \u7a0e\u989d[%s] \u4e4b\u95f4\u8bef\u5dee\u8d85\u8fc7" + offsetAmount.toPlainString(), billItem.getSalesbillItemId(), billItem.getItemName(), billItem.getAmountWithoutTax(), billItem.getTaxRate(), billItem.getTaxAmount()));
        }
        BigDecimal adjustTotalAmount = (BigDecimal)Arrays.stream(array).reduce(BigDecimal.ZERO, BigDecimal::add);
        adjustTotalAmount = errorAmount.compareTo(BigDecimal.ZERO) > 0 ? adjustTotalAmount : BigDecimal.ZERO.subtract(adjustTotalAmount);
        consumer2.accept(splitAmountInfo, BigDecimal.ZERO.subtract(adjustTotalAmount));
        return this.adjustResNew((BigDecimal[])array, result, consumer);
    }

    private List<ItemAmountInfo> adjustResNew(BigDecimal[] adjustValues, List<ItemAmountInfo> result, BiConsumer<ItemAmountInfo, BigDecimal> consumer) {
        for (int index = adjustValues.length - 1; index >= 0; --index) {
            consumer.accept(result.get(index), adjustValues[index]);
        }
        return result;
    }
}

