/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.PreInvoiceTemplateVersionStatus;
import com.xforceplus.phoenix.split.constant.RemarkConstant;
import com.xforceplus.phoenix.split.constant.SaleListOptionEnum;
import com.xforceplus.phoenix.split.constant.TaxInvoiceSourceEnum;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.ItemTypeCodeEnum;
import com.xforceplus.phoenix.split.model.PreInvoiceItem;
import com.xforceplus.phoenix.split.model.PreInvoiceMain;
import com.xforceplus.phoenix.split.model.SplitPreInvoiceInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.model.ZeroTaxOption;
import com.xforceplus.phoenix.split.service.PreInvoiceGenerateService;
import com.xforceplus.phoenix.split.service.RemarkService;
import com.xforceplus.phoenix.split.util.CommonTools;
import com.xforceplus.phoenix.split.util.ObjectCheckAndExcuteUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PreInvoiceGenerateServiceImpl
implements PreInvoiceGenerateService {
    private static final Logger logger = LoggerFactory.getLogger(PreInvoiceGenerateServiceImpl.class);
    public static final String CPY = "2";
    public static final String JDC = "jdc";
    public static final String CPY_ERROR_MESSAGE = "\u6210\u54c1\u6cb9\u53d1\u7968\u6570\u91cf\uff0c\u5355\u4f4d\u4e3a\u5fc5\u586b";
    @Autowired
    protected RemarkService remarkService;
    @Value(value="${cargoNameLengthLimit:100}")
    private int cargoNameLengthLimit;
    @Value(value="${skCargoNameLengthLimit}")
    private int skCargoNameLengthLimit;
    @Value(value="${unit.replace.list}")
    private String replaceUnit;
    private static final Charset GBK = Charset.forName("GBK");

    @Override
    public List<SplitPreInvoiceInfo> createPreInvoice(BillInfo billInfo, SplitRule rule) {
        List billItemList = billInfo.getBillItems();
        if (CollectionUtils.isEmpty((Collection)billItemList)) {
            return Lists.newArrayList();
        }
        if ((SaleListOptionEnum.ENABLE_LIST_OPTION.getValue().equals(rule.getSaleListOption()) || SaleListOptionEnum.FORCE_LIST_OPTION.getValue().equals(rule.getSaleListOption())) && billInfo.getInvoiceType().equals(InvoiceType.NORMAL_ROLL.value())) {
            throw new SplitBizException("\u5377\u7968\u4e0d\u652f\u6301\u9500\u8d27\u6e05\u5355");
        }
        SplitPreInvoiceInfo splitPreInvoiceInfo = this.generatePreInvoice(billInfo, rule);
        splitPreInvoiceInfo.getPreInvoiceMain().setRemark(this.toLegalRemark(billInfo, rule));
        return Lists.newArrayList((Object[])new SplitPreInvoiceInfo[]{splitPreInvoiceInfo});
    }

    protected SplitPreInvoiceInfo generatePreInvoice(BillInfo billInfo, SplitRule rule) {
        BillItem billItem0 = (BillItem)billInfo.getBillItems().get(0);
        boolean isRedItem = ((BillItem)billInfo.getBillItems().get(0)).isRedItem();
        if (rule.getZeroTaxOption().equals((Object)ZeroTaxOption.PROCESS) && billItem0.getTaxRate().equals(BigDecimal.ZERO)) {
            billInfo.setInvoiceType(InvoiceType.NORMAL.value());
        }
        String specialInvoiceFlag = this.buildSpecialInvoiceFlag(billItem0.getItemTypeCode());
        SplitPreInvoiceInfo splitPreInvoiceInfo = new SplitPreInvoiceInfo();
        splitPreInvoiceInfo.setRuleId(String.valueOf(rule.getRuleId()));
        splitPreInvoiceInfo.setPreInvoiceMain(this.createPreInvoiceMain(billInfo, rule, specialInvoiceFlag));
        splitPreInvoiceInfo.setPreInvoiceItems(this.createPreInvoiceItems(billInfo.getBillItems(), rule, isRedItem, splitPreInvoiceInfo.getPreInvoiceMain().getInvoiceType()));
        splitPreInvoiceInfo.getPreInvoiceMain().setSaleListFileFlag(Byte.valueOf(this.getPrintSalesListFlag(splitPreInvoiceInfo, rule) ? "1" : "0"));
        if (splitPreInvoiceInfo.getPreInvoiceMain().getSaleListFileFlag().equals(Byte.valueOf("1")) && !TaxInvoiceSourceEnum.QD.getValue().equals(rule.getTaxInvoiceSource()) && splitPreInvoiceInfo.getPreInvoiceItems().size() > rule.getSalesListMaxRow()) {
            throw new SplitBizException("\u660e\u7ec6\u884c\u6570\u8d85\u8fc7\u9500\u8d27\u6e05\u5355\u884c\u6570\uff01");
        }
        splitPreInvoiceInfo.getPreInvoiceMain().setListGoodsName(Byte.valueOf("1").equals(splitPreInvoiceInfo.getPreInvoiceMain().getSaleListFileFlag()) ? RemarkConstant.LIST_GOODS_NAME : "");
        List taxRateList = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getTaxRate).distinct().map(BigDecimal::toPlainString).collect(Collectors.toList());
        splitPreInvoiceInfo.getPreInvoiceMain().setTaxRate(Joiner.on((String)",").skipNulls().join(taxRateList));
        this.assemblePreInvoiceMainAmount(splitPreInvoiceInfo);
        return splitPreInvoiceInfo;
    }

    protected void assemblePreInvoiceMainAmount(SplitPreInvoiceInfo splitPreInvoiceInfo) {
        BigDecimal amountWithTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountWithTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getDiscountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal newAmountWithTax = amountWithTax.subtract(discountWithTax).setScale(2, 4);
        splitPreInvoiceInfo.getPreInvoiceMain().setAmountWithTax(newAmountWithTax);
        BigDecimal amountWithoutTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getAmountWithoutTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountWithoutTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getDiscountWithoutTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal newAmountWithoutTax = amountWithoutTax.subtract(discountWithoutTax).setScale(2, 4);
        splitPreInvoiceInfo.getPreInvoiceMain().setAmountWithoutTax(newAmountWithoutTax);
        BigDecimal taxAmount = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getDiscountTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal newTaxAmount = taxAmount.subtract(discountTax).setScale(2, 4);
        splitPreInvoiceInfo.getPreInvoiceMain().setTaxAmount(newTaxAmount);
    }

    protected String buildSpecialInvoiceFlag(String itemTypeCode) {
        return ItemTypeCodeEnum.getEnumByValueIgnoreCase((String)itemTypeCode).map(ItemTypeCodeEnum::getSpecialInvoiceFlag).orElse("0");
    }

    protected boolean getPrintSalesListFlag(SplitPreInvoiceInfo splitPreInvoiceInfo, SplitRule rule) {
        int itemSize = 0;
        for (PreInvoiceItem preInvoiceItem : splitPreInvoiceInfo.getPreInvoiceItems()) {
            itemSize = this.hasDiscount(preInvoiceItem) ? itemSize + 2 : itemSize + 1;
        }
        if (SaleListOptionEnum.DISABLE_LIST_OPTION.getValue().equals(rule.getSaleListOption()) || CPY.equals(splitPreInvoiceInfo.getPreInvoiceMain().getSpecialInvoiceFlag())) {
            return false;
        }
        if (SaleListOptionEnum.FORCE_LIST_OPTION.getValue().equals(rule.getSaleListOption())) {
            return true;
        }
        return TaxInvoiceSourceEnum.QD.getValue().equals(rule.getTaxInvoiceSource()) && itemSize > 8 || itemSize > rule.getInvoiceItemMaxRow();
    }

    private boolean hasDiscount(PreInvoiceItem preInvoiceItem) {
        return preInvoiceItem.getDiscountWithoutTax() != null && preInvoiceItem.getDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0;
    }

    private PreInvoiceMain createPreInvoiceMain(BillInfo billInfo, SplitRule rule, String specialInvoiceFlag) {
        PreInvoiceMain preInvoiceMain = new PreInvoiceMain();
        BeanUtils.copyProperties((Object)billInfo, (Object)preInvoiceMain);
        preInvoiceMain.setRuleId(rule.getRuleId());
        preInvoiceMain.setDisplayPriceQuality(Byte.valueOf(rule.getUnitPriceAmountOps()));
        preInvoiceMain.setSpecialInvoiceFlag(specialInvoiceFlag);
        preInvoiceMain.setTemplateVersion(null != rule.getInvoiceItemMaxRow() && rule.getInvoiceItemMaxRow() > 5 ? PreInvoiceTemplateVersionStatus.EIGHT.getValue() : PreInvoiceTemplateVersionStatus.FIVE.getValue());
        preInvoiceMain.setTaxInvoiceSource(rule.getTaxInvoiceSource());
        return preInvoiceMain;
    }

    public static void negateBigDecimalField(Object object) {
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                if (field.getType() != BigDecimal.class) continue;
                field.setAccessible(true);
                BigDecimal bigDecimal = (BigDecimal)field.get(object);
                if (!Objects.nonNull(bigDecimal)) continue;
                field.set(object, bigDecimal.negate());
            }
        }
        catch (IllegalAccessException e) {
            logger.error("negateBigDecimalField error:{}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<PreInvoiceItem> createPreInvoiceItems(List<BillItem> itemList, SplitRule rule, boolean isRedItem, String invoiceType) {
        Map unitMap = new HashMap();
        if (StringUtils.equals((CharSequence)rule.getTaxInvoiceSource(), (CharSequence)TaxInvoiceSourceEnum.QD.getValue())) {
            unitMap = (Map)JSON.parseObject((String)this.replaceUnit, Map.class);
        }
        ArrayList<PreInvoiceItem> preInvoiceItems = new ArrayList<PreInvoiceItem>(itemList.size());
        int cargoNameLengthLimit = this.getCargoNameLengthLimit(rule, invoiceType);
        for (BillItem billItem : itemList) {
            String replaceUnit;
            PreInvoiceItem preInvoiceItem = new PreInvoiceItem();
            preInvoiceItems.add(preInvoiceItem);
            BeanUtils.copyProperties((Object)billItem, (Object)preInvoiceItem);
            billItem.setAmountWithoutTax(billItem.getAmountWithoutTax().setScale(2, RoundingMode.HALF_UP));
            billItem.setAmountWithTax(billItem.getAmountWithTax().setScale(2, RoundingMode.HALF_UP));
            billItem.setTaxAmount(billItem.getAmountWithTax().setScale(2, RoundingMode.HALF_UP));
            billItem.setDiscountWithoutTax(billItem.getDiscountWithoutTax().setScale(2, RoundingMode.HALF_UP));
            billItem.setDiscountWithTax(billItem.getDiscountWithTax().setScale(2, RoundingMode.HALF_UP));
            billItem.setDiscountTax(billItem.getDiscountTax().setScale(2, RoundingMode.HALF_UP));
            if (isRedItem) {
                PreInvoiceGenerateServiceImpl.negateBigDecimalField(preInvoiceItem);
            }
            preInvoiceItem.setUnitPrice(preInvoiceItem.getUnitPrice().abs());
            preInvoiceItem.setTaxRate(preInvoiceItem.getTaxRate().abs());
            preInvoiceItem.setCargoCode(billItem.getItemCode());
            this.setCargoName(billItem, preInvoiceItem, rule);
            if (StringUtils.equals((CharSequence)rule.getTaxInvoiceSource(), (CharSequence)TaxInvoiceSourceEnum.QD.getValue()) && InvoiceType.isElectronic(invoiceType)) {
                if (this.cargoNameGtLimitForQd(preInvoiceItem.getCargoName(), cargoNameLengthLimit)) {
                    preInvoiceItem.setCargoName(StringUtils.substring((String)preInvoiceItem.getCargoName(), (int)0, (int)cargoNameLengthLimit));
                }
            } else if (this.cargoNameGtLimit(preInvoiceItem.getCargoName(), cargoNameLengthLimit)) {
                preInvoiceItem.setCargoName(CommonTools.substring(preInvoiceItem.getCargoName(), cargoNameLengthLimit, GBK));
            }
            preInvoiceItem.setPrintContentFlag(this.getPrintContentFlag(rule, billItem));
            preInvoiceItem.setTaxItem("");
            preInvoiceItem.setDeduction(billItem.getDeductions());
            preInvoiceItem.setGoodsTaxNo(this.getStrOrDefaultStr(billItem.getGoodsTaxNo(), ""));
            preInvoiceItem.setTaxPre(this.getStrOrDefaultStr(billItem.getTaxPre(), "0"));
            preInvoiceItem.setZeroTax(this.getStrOrDefaultStr(billItem.getZeroTax(), ""));
            preInvoiceItem.setPriceMethod(String.valueOf(rule.getPriceMethod().value()));
            ObjectCheckAndExcuteUtils.docheckAndExcute(rule, SplitRule::getShowSpecification, x -> x, x -> {
                preInvoiceItem.setItemSpec("");
                return x;
            });
            this.emptyFieldValue(preInvoiceItem, rule);
            this.adjustBillItemAmountWithoutTax(preInvoiceItem);
            if (!StringUtils.equals((CharSequence)rule.getTaxInvoiceSource(), (CharSequence)TaxInvoiceSourceEnum.QD.getValue()) || unitMap == null || !StringUtils.isNotBlank((CharSequence)preInvoiceItem.getQuantityUnit()) || (replaceUnit = (String)unitMap.get(preInvoiceItem.getQuantityUnit())) == null) continue;
            preInvoiceItem.setQuantityUnit(replaceUnit);
        }
        return preInvoiceItems;
    }

    protected void adjustBillItemAmountWithoutTax(PreInvoiceItem item) {
        BigDecimal offsetTaxAmount;
        if (item.getDiscountWithTax().compareTo(BigDecimal.ZERO) != 0 && item.getAmountWithoutTax().compareTo(item.getDiscountWithoutTax()) == 0 && ((offsetTaxAmount = item.getTaxAmount().subtract(item.getDiscountTax())).compareTo(BigDecimal.valueOf(0.01)) == 0 || offsetTaxAmount.compareTo(BigDecimal.valueOf(0.02)) == 0)) {
            item.setDiscountTax(item.getDiscountTax().add(BigDecimal.valueOf(0.01)));
            item.setDiscountWithoutTax(item.getDiscountWithoutTax().subtract(BigDecimal.valueOf(0.01)));
        }
        if (item.getAmountWithTax().compareTo(BigDecimal.valueOf(0.01)) == 0 && item.getTaxAmount().compareTo(BigDecimal.valueOf(0.01)) == 0 && item.getDiscountWithTax().compareTo(BigDecimal.ZERO) == 0) {
            item.setAmountWithoutTax(BigDecimal.valueOf(0.01));
            item.setTaxAmount(BigDecimal.ZERO);
        } else if (item.getAmountWithTax().compareTo(BigDecimal.valueOf(-0.01)) == 0 && item.getTaxAmount().compareTo(BigDecimal.valueOf(-0.01)) == 0 && item.getDiscountWithTax().compareTo(BigDecimal.ZERO) == 0) {
            item.setAmountWithoutTax(BigDecimal.valueOf(-0.01));
            item.setTaxAmount(BigDecimal.ZERO);
        }
    }

    protected void emptyFieldValue(PreInvoiceItem preInvoiceItem, SplitRule rule) {
        boolean isRedItem;
        String itemTypeCode = preInvoiceItem.getItemTypeCode();
        BigDecimal amountWithoutTax = preInvoiceItem.getAmountWithoutTax();
        boolean bl = isRedItem = amountWithoutTax != null && amountWithoutTax.compareTo(BigDecimal.ZERO) < 0;
        if (Objects.equals("1", rule.getUnitPriceAmountOps()) && (!ItemTypeCodeEnum.OIL.getValue().equals(itemTypeCode) && !ItemTypeCodeEnum.MINERALS.getValue().equals(itemTypeCode) || isRedItem)) {
            preInvoiceItem.setUnitPrice(BigDecimal.ZERO);
            preInvoiceItem.setQuantity(BigDecimal.ZERO);
        }
        if (!rule.isPrintItemSpecFlag()) {
            preInvoiceItem.setItemSpec("");
        }
    }

    private String getStrOrDefaultStr(String str, String defaultStr) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultStr;
        }
        return str;
    }

    private String getPrintContentFlag(SplitRule rule, BillItem billItem) {
        return BigDecimal.ZERO.compareTo(billItem.getQuantity()) == 0 && BigDecimal.ZERO.compareTo(billItem.getUnitPrice()) == 0 ? "1" : (StringUtils.isNotEmpty((CharSequence)rule.getUnitPriceAmountOps()) ? rule.getUnitPriceAmountOps() : "0");
    }

    private void setCargoName(BillItem billItem, PreInvoiceItem preInvoiceItem, SplitRule rule) {
        boolean hideCargoNameItemShortName = rule.isHideCargoNameItemShortName();
        if (StringUtils.isNotBlank((CharSequence)billItem.getItemShortName()) && !hideCargoNameItemShortName) {
            String cargoName = RemarkConstant.TAX_CODE_SHORT_NAME_JOINER_PREFIX + billItem.getItemShortName() + RemarkConstant.TAX_CODE_SHORT_NAME_JOINER_SUFFIX;
            cargoName = StringUtils.isNotBlank((CharSequence)billItem.getJoinName()) ? cargoName + billItem.getJoinName() : cargoName + billItem.getItemName();
            preInvoiceItem.setCargoName(cargoName);
        } else if (StringUtils.isNotBlank((CharSequence)billItem.getJoinName())) {
            preInvoiceItem.setCargoName(billItem.getJoinName());
        } else {
            preInvoiceItem.setCargoName(billItem.getItemName());
        }
    }

    private int getCargoNameLengthLimit(SplitRule rule, String invoiceType) {
        if (StringUtils.equals((CharSequence)rule.getTaxInvoiceSource(), (CharSequence)TaxInvoiceSourceEnum.QD.getValue()) && InvoiceType.isElectronic(invoiceType)) {
            return Optional.ofNullable(rule.getCargoNameLength()).filter(r -> r <= this.cargoNameLengthLimit).orElse(this.cargoNameLengthLimit);
        }
        return Optional.ofNullable(rule.getCargoNameLength()).filter(r -> r <= this.skCargoNameLengthLimit).orElse(this.skCargoNameLengthLimit);
    }

    private boolean cargoNameGtLimit(String cargoName, int cargoNameLengthLimit) {
        return cargoName.getBytes(GBK).length > cargoNameLengthLimit;
    }

    private boolean cargoNameGtLimitForQd(String cargoName, int cargoNameLengthLimit) {
        return cargoName.length() > cargoNameLengthLimit;
    }

    private String toLegalRemark(BillInfo billInfo, SplitRule rule) {
        String remark = this.remarkService.splice(billInfo, rule);
        return this.adjustRemark(billInfo, rule, remark);
    }

    public String adjustRemark(BillInfo billInfo, SplitRule rule, String remark) {
        Integer remarkSizeLimit = rule.getCustomRemarkSize();
        if (Objects.isNull(remarkSizeLimit)) {
            remarkSizeLimit = TaxInvoiceSourceEnum.QD.getValue().equals(rule.getTaxInvoiceSource()) ? Integer.valueOf(RemarkConstant.QD_SIZE) : (InvoiceType.ELECTRONIC.value().equals(billInfo.getInvoiceType()) ? Integer.valueOf(RemarkConstant.ELECTRONIC_SIZE) : Integer.valueOf(RemarkConstant.DEFAULT_SIZE));
        }
        if (TaxInvoiceSourceEnum.QD.getValue().equals(rule.getTaxInvoiceSource()) && InvoiceType.isElectronic(billInfo.getInvoiceType())) {
            int endIndex = remarkSizeLimit > remark.length() ? remark.length() : remarkSizeLimit.intValue();
            return remark.substring(0, endIndex);
        }
        return RemarkService.toLegalRemark(remark, remarkSizeLimit);
    }
}

