/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.xforceplus.phoenix.split.checker.SplitLimitChecker;
import com.xforceplus.phoenix.split.constant.SplitBillItemAmountType;
import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.AmountSplitRuleUtils;
import com.xforceplus.phoenix.split.service.SplitBillItemAmountService;
import com.xforceplus.phoenix.split.service.impl.AbstractSplitBillItemAmountService;
import com.xforceplus.phoenix.split.translator.mapper.SplitAmountMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SplitBillItemAmountByQuantityAndAmountLimitServiceImpl
extends AbstractSplitBillItemAmountService
implements SplitBillItemAmountService {
    private static final Logger log = LoggerFactory.getLogger(SplitBillItemAmountByQuantityAndAmountLimitServiceImpl.class);
    private final SplitAmountMapper splitAmountMapper;
    private final SplitLimitChecker splitLimitChecker;

    public SplitBillItemAmountByQuantityAndAmountLimitServiceImpl(SplitAmountMapper splitAmountMapper, SplitLimitChecker splitLimitChecker) {
        this.splitAmountMapper = splitAmountMapper;
        this.splitLimitChecker = splitLimitChecker;
    }

    @Override
    public List<ItemAmountInfo> splitAmount(ItemAmountInfo itemAmountInfo, SplitRule rule) {
        ItemAmountInfo originalItem = this.splitAmountMapper.copy(itemAmountInfo);
        super.mergeDiscountAmount(originalItem);
        BillItem billItem = super.getBillItemFromThreadLocal();
        BigDecimal quantityLimit = (BigDecimal)rule.getQuantityLimitMap().get(billItem.getQuantityUnit());
        SplitBillItemAmountType splitBillItemAmountType = this.chooseSplitBillItemAmountType(rule, quantityLimit, originalItem);
        BigDecimal invoiceLimit = rule.getInvoiceLimit();
        List<ItemAmountInfo> result = new LinkedList<ItemAmountInfo>();
        while (this.splitLimitChecker.gtLimit(originalItem, rule, quantityLimit)) {
            ItemAmountInfo splitItemAmountInfo;
            switch (splitBillItemAmountType) {
                case SPLIT_BY_QUANTITY: {
                    splitItemAmountInfo = this.splitItemAmountInfoByQuantity(rule, originalItem, quantityLimit);
                    break;
                }
                case SPLIT_BY_AMOUNT_WITH_TAX: {
                    splitItemAmountInfo = this.splitItemAmountInfoByAmountWithTax(rule, originalItem, invoiceLimit);
                    break;
                }
                default: {
                    splitItemAmountInfo = this.splitItemAmountInfoByAmountWithoutTax(rule, originalItem, invoiceLimit);
                }
            }
            super.deductSplitItemAmount(rule, originalItem, splitItemAmountInfo);
            result.add(splitItemAmountInfo);
        }
        if (SplitBillItemAmountType.SPLIT_BY_QUANTITY != splitBillItemAmountType) {
            super.processLastItemUnitPriceAndQuantity(originalItem, true, rule);
        }
        result = super.processLastItemErrorAmount(originalItem, result, rule);
        return result;
    }

    protected ItemAmountInfo splitItemAmountInfoByQuantity(SplitRule rule, ItemAmountInfo originalItem, BigDecimal quantityLimit) {
        BigDecimal limitQuantity = this.formatLimitQuantity(rule, quantityLimit);
        return originalItem.createItemAmountByQuantity(limitQuantity);
    }

    protected ItemAmountInfo splitItemAmountInfoByAmountWithoutTax(SplitRule rule, ItemAmountInfo originalItem, BigDecimal invoiceLimit) {
        return originalItem.createItemAmountByAmountWithoutTax(rule, invoiceLimit);
    }

    protected ItemAmountInfo splitItemAmountInfoByAmountWithTax(SplitRule rule, ItemAmountInfo originalItem, BigDecimal invoiceLimit) {
        return originalItem.createItemAmountByAmountWithTax(rule, invoiceLimit);
    }

    private SplitBillItemAmountType chooseSplitBillItemAmountType(SplitRule rule, BigDecimal quantityLimit, ItemAmountInfo originalItem) {
        BigDecimal amountSplitRate;
        BigDecimal invoiceLimit = rule.getInvoiceLimit();
        BigDecimal quantitySplitRate = quantityLimit.divide(originalItem.getQuantity(), 10, RoundingMode.DOWN);
        BigDecimal bigDecimal = amountSplitRate = rule.isLimitIsAmountWithTax() ? invoiceLimit.divide(originalItem.getAmountWithTax().subtract(originalItem.getDiscountWithTax()), 10, RoundingMode.DOWN) : invoiceLimit.divide(originalItem.getAmountWithoutTax().subtract(originalItem.getDiscountWithoutTax()), 10, RoundingMode.DOWN);
        if (quantitySplitRate.compareTo(amountSplitRate) <= 0 && quantityLimit.multiply(originalItem.getUnitPrice()).compareTo(invoiceLimit) <= 0) {
            return SplitBillItemAmountType.SPLIT_BY_QUANTITY;
        }
        return rule.isLimitIsAmountWithTax() ? SplitBillItemAmountType.SPLIT_BY_AMOUNT_WITH_TAX : SplitBillItemAmountType.SPLIT_BY_AMOUNT_WITHOUT_TAX;
    }

    private BigDecimal formatLimitQuantity(SplitRule rule, BigDecimal currentQuantity) {
        if (AmountSplitRuleUtils.isUnitPriceAndQuantityInteger(rule.getAmountSplitRule())) {
            return currentQuantity.setScale(0, RoundingMode.DOWN);
        }
        return currentQuantity;
    }
}

