/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.util;

import com.google.common.base.Stopwatch;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.List;
import java.util.UUID;
import java.util.zip.Deflater;
import javax.annotation.Nullable;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.util.StringUtils;

public class CommonTools {
    private static final Logger logger = LoggerFactory.getLogger(CommonTools.class);

    public static String format(String format, Object ... args) {
        return MessageFormatter.arrayFormat((String)format, (Object[])args).getMessage();
    }

    public static boolean isEdit(Long id) {
        return id != null && id > 0L;
    }

    public static int getStringRealLength(String str) {
        char[] strChars;
        int strLength = 0;
        for (char c : strChars = str.trim().toCharArray()) {
            if (CommonTools.isChinese(c)) {
                strLength += 2;
                continue;
            }
            if (CommonTools.isEnglishWord(c + "")) {
                ++strLength;
                continue;
            }
            if (CommonTools.isNumeric(c)) {
                ++strLength;
                continue;
            }
            if (CommonTools.isEnglishSymbol(c + "")) {
                ++strLength;
                continue;
            }
            ++strLength;
        }
        return strLength;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static boolean isEnglishSymbol(String charaString) {
        return charaString.matches("^[%&',;=?$_\\-\\(\\)\\[\\]\\*]*");
    }

    public static boolean isEnglishWord(String charaString) {
        return charaString.matches("^[a-zA-Z]*");
    }

    public static boolean isNumeric(char num) {
        return Character.isDigit(num);
    }

    public static String fill(String str, int length) {
        String backStr = str;
        while (backStr.length() < length) {
            backStr = "0" + backStr;
        }
        return backStr;
    }

    public static String fill5(int i) {
        return CommonTools.fill(i + "", 5);
    }

    public static boolean isEmpty(String s) {
        return !StringUtils.hasText((String)s);
    }

    public static boolean isEmpty(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static String createOssObjName(@Nullable String key) {
        if (!StringUtils.hasText((String)key)) {
            key = UUID.randomUUID().toString().replaceAll("-", "").toLowerCase();
        }
        LocalDate now = LocalDate.now();
        return now.getYear() + "/" + now.getMonthValue() + "/" + now.getDayOfMonth() + "/" + key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] compress(byte[] inputByte) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int len = 0;
        Deflater defl = new Deflater();
        defl.setInput(inputByte);
        defl.finish();
        byte[] outputByte = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            while (!defl.finished()) {
                len = defl.deflate(outputByte);
                bos.write(outputByte, 0, len);
            }
            defl.end();
            logger.info("compress time = {}", (Object)stopwatch.elapsed().toMillis());
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException("compress fail!");
        }
    }

    public static String substring(String text, int length, Charset charset) {
        if (text == null) {
            return null;
        }
        if (text.getBytes(charset).length < length) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        int currentLength = 0;
        for (char c : text.toCharArray()) {
            if ((currentLength += String.valueOf(c).getBytes(charset).length) > length) break;
            sb.append(c);
        }
        return sb.toString();
    }

    public static BigDecimal getBigDecimal(String amount) {
        try {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)amount) || !NumberUtils.isNumber((String)amount)) {
                return null;
            }
            return new BigDecimal(amount);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return BigDecimal.ZERO;
        }
    }
}

