/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.discount.service;

import com.xforceplus.discount.service.AbstractOrderService;
import com.xforceplus.discount.service.IOrderTranserService;
import com.xforceplus.discount.vo.DiscountRule;
import com.xforceplus.discount.vo.SourceOrder;
import com.xforceplus.discount.vo.TargetOrder;
import io.vavr.Tuple2;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderPosTranserServiceImpl
extends AbstractOrderService
implements IOrderTranserService {
    private static final Logger log = LoggerFactory.getLogger(OrderPosTranserServiceImpl.class);

    @Override
    public String key() {
        return "POS";
    }

    @Override
    public Tuple2<String, TargetOrder> transer(SourceOrder order, List<DiscountRule> rules) {
        return this.convertNotCoupon(order);
    }

    private Tuple2<String, TargetOrder> convertNotCoupon(SourceOrder order) {
        TargetOrder.OrderDetail packageDetail;
        TargetOrder targetOrder = new TargetOrder();
        targetOrder.setId(order.getId());
        targetOrder.setSource(order.getSource());
        targetOrder.setAmountWithTax(order.getAmountWithTax());
        targetOrder.setDiscountWithTax(order.getDiscountWithTax());
        List<TargetOrder.OrderDetail> targetDetails = super.convertWithDsicount(order.getDetailList(), order.getDiscountWithTax());
        TargetOrder.OrderDetail deliveryDetail = super.fillDeliveryGoods(order.getDeliveryWithTax(), order.getDiscountList());
        if (deliveryDetail != null) {
            targetDetails.add(deliveryDetail);
        }
        if ((packageDetail = super.fillPackageGoods(order.getPackageWithTax())) != null) {
            targetDetails.add(packageDetail);
        }
        if (order.getActualAmount() != null) {
            BigDecimal totalAmountWithTax = targetDetails.stream().map(detail -> detail.getAmountWithTax().subtract(detail.getDiscountWithTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (order.getActualAmount().compareTo(totalAmountWithTax) != 0) {
                return new Tuple2((Object)"\u660e\u7ec6\u7d2f\u8ba1\u91d1\u989d\u4e0d\u7b49\u4e3b\u4fe1\u606f\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u5355\u636e", null);
            }
        }
        targetOrder.setDetailList(targetDetails);
        return new Tuple2((Object)"", (Object)targetOrder);
    }
}

