/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.discount.service;

import com.google.common.collect.Lists;
import com.xforceplus.discount.enums.SalesSourceEnum;
import com.xforceplus.discount.service.AbstractOrderService;
import com.xforceplus.discount.service.IOrderTranserService;
import com.xforceplus.discount.vo.DiscountRule;
import com.xforceplus.discount.vo.SourceOrder;
import com.xforceplus.discount.vo.TargetOrder;
import io.vavr.Tuple2;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderQimaiTranserServiceImpl
extends AbstractOrderService
implements IOrderTranserService {
    private static final Logger log = LoggerFactory.getLogger(OrderQimaiTranserServiceImpl.class);

    @Override
    public String key() {
        return "QMAIXIAOCHENGXU";
    }

    @Override
    public Tuple2<String, TargetOrder> transer(SourceOrder order, List<DiscountRule> rules) {
        if (order == null || CollectionUtils.isEmpty(order.getDiscountList())) {
            return this.convertNotCoupon(order);
        }
        if (CollectionUtils.isNotEmpty(order.getDiscountList()) && CollectionUtils.isNotEmpty(rules)) {
            Map<String, DiscountRule> ruleMap = rules.stream().collect(Collectors.toMap(v -> v.getDiscountSource() + "-" + v.getBrand(), v -> v, (a, b) -> a));
            order.getDiscountList().forEach(v -> {
                DiscountRule rule = (DiscountRule)ruleMap.get(v.getDiscountSource() + "-" + order.getBrand());
                if (rule != null) {
                    v.setSalesSource(rule.getSalesSource());
                }
            });
        }
        return this.convertWithCoupon(order);
    }

    private Tuple2<String, TargetOrder> convertNotCoupon(SourceOrder order) {
        TargetOrder.OrderDetail packageDetail;
        TargetOrder targetOrder = new TargetOrder();
        targetOrder.setId(order.getId());
        targetOrder.setSource(order.getSource());
        targetOrder.setAmountWithTax(order.getAmountWithTax());
        targetOrder.setDiscountWithTax(order.getDiscountWithTax());
        List<TargetOrder.OrderDetail> targetDetails = super.convertWithDsicount(order.getDetailList(), order.getDiscountWithTax());
        TargetOrder.OrderDetail deliveryDetail = super.fillDeliveryGoods(order.getDeliveryWithTax(), order.getDiscountList());
        if (deliveryDetail != null) {
            targetDetails.add(deliveryDetail);
        }
        if ((packageDetail = super.fillPackageGoods(order.getPackageWithTax())) != null) {
            targetDetails.add(packageDetail);
        }
        if (order.getActualAmount() != null) {
            BigDecimal totalAmountWithTax = targetDetails.stream().map(detail -> detail.getAmountWithTax().subtract(detail.getDiscountWithTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (order.getActualAmount().compareTo(totalAmountWithTax) != 0) {
                return new Tuple2((Object)"\u660e\u7ec6\u7d2f\u8ba1\u91d1\u989d\u4e0d\u7b49\u4e3b\u4fe1\u606f\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u5355\u636e", null);
            }
        }
        return new Tuple2((Object)"", (Object)targetOrder);
    }

    private Tuple2<String, TargetOrder> convertWithCoupon(SourceOrder order) {
        BigDecimal totalAmountWithTax;
        TargetOrder.OrderDetail orderDetail;
        TargetOrder targetOrder = new TargetOrder();
        targetOrder.setId(order.getId());
        targetOrder.setSource(order.getSource());
        targetOrder.setAmountWithTax(order.getAmountWithTax());
        Map<String, SourceOrder.Discount> discountMap = order.getDiscountList().stream().collect(Collectors.toMap(SourceOrder.Discount::getDiscountId, v -> v, (a, b) -> a));
        HashMap<String, ArrayList> minimumMap = new HashMap<String, ArrayList>();
        ArrayList targetDetails = Lists.newArrayList();
        for (int i = 0; i < order.getDetailList().size(); ++i) {
            SourceOrder.OrderDetail orderDetail2 = order.getDetailList().get(i);
            TargetOrder.OrderDetail orderDetail3 = new TargetOrder.OrderDetail();
            orderDetail3.setAmountWithTax(orderDetail2.getAmountWithTax());
            orderDetail3.setQuantity(orderDetail2.getQuantity());
            orderDetail3.setUnitPrice(orderDetail2.getUnitPrice());
            orderDetail3.setItemName(orderDetail2.getItemName());
            orderDetail3.setItemNo(orderDetail2.getItemNo());
            orderDetail3.setIndex(String.valueOf(i));
            orderDetail3.setUnit(orderDetail2.getUnit());
            orderDetail3.setItemSpec(orderDetail2.getItemSpec());
            orderDetail3.setTaxConvertCode(orderDetail2.getTaxConvertCode());
            orderDetail3.setDiscountWithTax(orderDetail3.getDiscountWithTax() == null ? BigDecimal.ZERO : orderDetail3.getDiscountWithTax());
            for (String discountId : orderDetail2.getDiscountIds()) {
                SourceOrder.Discount discount = discountMap.get(discountId);
                if (discount == null) {
                    return new Tuple2((Object)(discountId + ":\u65e0\u6cd5\u5339\u914d\u5230\u5bf9\u5e94\u7684\u4f18\u60e0\u5238"), null);
                }
                if (discount.getReceivedWithTax() != null && discount.getReceivedWithTax().compareTo(BigDecimal.ZERO) > 0) {
                    if (StringUtils.equals((CharSequence)discount.getSalesSource(), (CharSequence)SalesSourceEnum.HEAD.getCode())) {
                        if (discount.getAmountWithTax().compareTo(orderDetail3.getAmountWithTax()) > 0) {
                            discount.setAmountWithTax(discount.getAmountWithTax().subtract(orderDetail3.getAmountWithTax()));
                            orderDetail3.setAmountWithTax(BigDecimal.ZERO);
                        } else {
                            orderDetail3.setAmountWithTax(orderDetail3.getAmountWithTax().subtract(discount.getAmountWithTax()));
                        }
                        orderDetail3.setUnitPrice(orderDetail3.getAmountWithTax().divide(orderDetail3.getQuantity(), 2, 4));
                        continue;
                    }
                    if (minimumMap.get(discountId) == null) {
                        minimumMap.put(discountId, Lists.newArrayList((Object[])new TargetOrder.OrderDetail[]{orderDetail3}));
                        continue;
                    }
                    ((List)minimumMap.get(discountId)).add(orderDetail3);
                    continue;
                }
                orderDetail3.setDiscountWithTax(orderDetail3.getDiscountWithTax().add(discount.getAmountWithTax()));
            }
            if (orderDetail3.getAmountWithTax().compareTo(BigDecimal.ZERO) == 0) continue;
            targetDetails.add(orderDetail3);
        }
        Map<String, TargetOrder.OrderDetail> targetDetailMap = targetDetails.stream().collect(Collectors.toMap(TargetOrder.OrderDetail::getIndex, v -> v, (a, b) -> a));
        for (Map.Entry entry : minimumMap.entrySet()) {
            BigDecimal totalDiscountWithTax;
            SourceOrder.Discount discount = discountMap.get(entry.getKey());
            if (discount == null) {
                return new Tuple2((Object)((String)entry.getKey() + ":\u65e0\u6cd5\u5339\u914d\u5230\u5bf9\u5e94\u7684\u4f18\u60e0\u5238"), null);
            }
            BigDecimal sumAmountWithTax = ((List)entry.getValue()).stream().map(TargetOrder.OrderDetail::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal leftDiscountAmount = totalDiscountWithTax = discount.getAmountWithTax().subtract(discount.getReceivedWithTax());
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                TargetOrder.OrderDetail targetDetail;
                targetDetail.setDiscountWithTax((targetDetail = targetDetailMap.get(((TargetOrder.OrderDetail)((List)entry.getValue()).get(i)).getIndex())).getDiscountWithTax() == null ? BigDecimal.ZERO : targetDetail.getDiscountWithTax());
                if (totalDiscountWithTax == null || totalDiscountWithTax.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal proportion = targetDetail.getAmountWithTax().divide(sumAmountWithTax, 2, 4);
                BigDecimal detailDiscountWithTax = proportion.multiply(totalDiscountWithTax);
                targetDetail.setDiscountWithTax(detailDiscountWithTax);
                if (i == ((List)entry.getValue()).size() - 1) {
                    targetDetail.setDiscountWithTax(leftDiscountAmount);
                }
                leftDiscountAmount = leftDiscountAmount.subtract(detailDiscountWithTax);
            }
        }
        TargetOrder.OrderDetail deliveryDetail = super.fillDeliveryGoods(order.getDeliveryWithTax(), order.getDiscountList());
        if (deliveryDetail != null) {
            targetDetails.add(deliveryDetail);
        }
        if ((orderDetail = super.fillPackageGoods(order.getPackageWithTax())) != null) {
            targetDetails.add(orderDetail);
        }
        if (order.getActualAmount() != null) {
            totalAmountWithTax = targetDetails.stream().map(detail -> detail.getAmountWithTax().subtract(detail.getDiscountWithTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (order.getActualAmount().compareTo(totalAmountWithTax) != 0) {
                return new Tuple2((Object)"\u660e\u7ec6\u7d2f\u8ba1\u91d1\u989d\u4e0d\u7b49\u4e3b\u4fe1\u606f\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u5355\u636e", null);
            }
        }
        totalAmountWithTax = targetDetails.stream().map(detail -> detail.getAmountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountAmountWithTax = targetDetails.stream().map(detail -> detail.getDiscountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        targetOrder.setAmountWithTax(totalAmountWithTax);
        targetOrder.setDiscountWithTax(discountAmountWithTax);
        targetOrder.setDetailList(targetDetails);
        return new Tuple2((Object)"", (Object)targetOrder);
    }
}

