/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.discount.service;

import com.xforceplus.discount.enums.CouponTypeEnum;
import com.xforceplus.discount.vo.SourceOrder;
import com.xforceplus.discount.vo.TargetOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class AbstractOrderService {
    List<TargetOrder.OrderDetail> convertWithDsicount(List<SourceOrder.OrderDetail> orderDetails, BigDecimal discountWithTax) {
        ArrayList<TargetOrder.OrderDetail> targetDetails = new ArrayList<TargetOrder.OrderDetail>();
        BigDecimal sumAmountWithTax = orderDetails.stream().map(SourceOrder.OrderDetail::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal leftDiscountAmount = discountWithTax;
        for (int i = 0; i < orderDetails.size(); ++i) {
            SourceOrder.OrderDetail orderDetail = orderDetails.get(i);
            TargetOrder.OrderDetail detail = new TargetOrder.OrderDetail();
            detail.setAmountWithTax(orderDetail.getAmountWithTax());
            detail.setQuantity(orderDetail.getQuantity());
            detail.setUnitPrice(orderDetail.getUnitPrice());
            detail.setItemName(orderDetail.getItemName());
            detail.setItemNo(orderDetail.getItemNo());
            detail.setIndex(String.valueOf(i));
            detail.setUnit(orderDetail.getUnit());
            detail.setItemSpec(orderDetail.getItemSpec());
            detail.setTaxConvertCode(orderDetail.getTaxConvertCode());
            detail.setItemCode(orderDetail.getItemCode());
            detail.setDiscountWithTax(orderDetail.getDiscountWithTax() == null ? BigDecimal.ZERO : orderDetail.getDiscountWithTax());
            if (discountWithTax != null && discountWithTax.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal proportion = orderDetail.getAmountWithTax().divide(sumAmountWithTax, 2, 4);
                BigDecimal detailDiscountWithTax = proportion.multiply(discountWithTax);
                detail.setDiscountWithTax(detailDiscountWithTax);
                if (i == orderDetails.size() - 1) {
                    detail.setDiscountWithTax(leftDiscountAmount);
                }
                leftDiscountAmount = leftDiscountAmount.subtract(detailDiscountWithTax);
            }
            targetDetails.add(detail);
        }
        return targetDetails;
    }

    public TargetOrder.OrderDetail fillPackageGoods(BigDecimal packageWithTax) {
        if (packageWithTax == null || packageWithTax.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        TargetOrder.OrderDetail orderDetail = new TargetOrder.OrderDetail();
        orderDetail.setIndex("dbf");
        orderDetail.setItemName("\u6253\u5305\u8d39");
        orderDetail.setItemCode("PYT-CHANNEL-PACK");
        orderDetail.setQuantity(BigDecimal.ONE);
        orderDetail.setAmountWithTax(packageWithTax);
        orderDetail.setUnitPrice(packageWithTax);
        orderDetail.setDiscountWithTax(BigDecimal.ZERO);
        return orderDetail;
    }

    public TargetOrder.OrderDetail fillDeliveryGoods(BigDecimal deliveryWithTax, List<SourceOrder.Discount> discountList) {
        if (deliveryWithTax == null || deliveryWithTax.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        TargetOrder.OrderDetail orderDetail = new TargetOrder.OrderDetail();
        orderDetail.setIndex("psf");
        orderDetail.setItemName("\u914d\u9001\u8d39");
        orderDetail.setItemCode("PYT-CHANNEL-DELIVERY");
        orderDetail.setQuantity(BigDecimal.ONE);
        orderDetail.setAmountWithTax(deliveryWithTax);
        orderDetail.setUnitPrice(deliveryWithTax);
        orderDetail.setDiscountWithTax(BigDecimal.ZERO);
        if (CollectionUtils.isNotEmpty(discountList)) {
            BigDecimal discountAmount = discountList.stream().filter(v -> StringUtils.equals((CharSequence)v.getDiscountType(), (CharSequence)String.valueOf(CouponTypeEnum.DELIVERY_FEE_DISCOUNT.getCode()))).map(SourceOrder.Discount::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (deliveryWithTax.compareTo(discountAmount) <= 0) {
                orderDetail.setDiscountWithTax(deliveryWithTax);
            } else {
                orderDetail.setDiscountWithTax(discountAmount);
            }
        }
        return orderDetail;
    }
}

