/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.discount.service;

import com.google.common.collect.Lists;
import com.xforceplus.discount.enums.CouponTypeEnum;
import com.xforceplus.discount.enums.SalesSourceEnum;
import com.xforceplus.discount.service.AbstractOrderService;
import com.xforceplus.discount.service.IOrderTranserService;
import com.xforceplus.discount.vo.DiscountRule;
import com.xforceplus.discount.vo.SourceOrder;
import com.xforceplus.discount.vo.TargetOrder;
import io.vavr.Tuple2;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderQimaiTranserServiceImpl
extends AbstractOrderService
implements IOrderTranserService {
    private static final Logger log = LoggerFactory.getLogger(OrderQimaiTranserServiceImpl.class);

    @Override
    public String key() {
        return "QMAIXIAOCHENGXU";
    }

    @Override
    public Tuple2<String, TargetOrder> transer(SourceOrder order, List<DiscountRule> rules) {
        if (CollectionUtils.isEmpty(order.getDiscountList())) {
            return this.convertNotCoupon(order);
        }
        if (CollectionUtils.isNotEmpty(order.getDiscountList()) && CollectionUtils.isNotEmpty(rules)) {
            Map<String, DiscountRule> ruleMap = rules.stream().collect(Collectors.toMap(v -> v.getDiscountSource() + "-" + v.getBrand(), v -> v, (a, b) -> a));
            order.getDiscountList().forEach(v -> {
                DiscountRule rule = (DiscountRule)ruleMap.get(v.getDiscountSource() + "-" + order.getBrand());
                if (rule != null) {
                    v.setSalesSource(rule.getSalesSource());
                }
            });
        }
        return this.convertWithCoupon(order);
    }

    private Tuple2<String, TargetOrder> convertNotCoupon(SourceOrder order) {
        BigDecimal totalAmountWithTax;
        TargetOrder targetOrder = new TargetOrder();
        targetOrder.setId(order.getId());
        targetOrder.setOrderNo(order.getOrderNo());
        targetOrder.setSource(order.getSource());
        targetOrder.setAmountWithTax(order.getAmountWithTax());
        targetOrder.setDiscountWithTax(order.getDiscountWithTax());
        List<TargetOrder.OrderDetail> targetDetails = super.convertWithDsicount(order.getDetailList(), order.getDiscountWithTax(), order.getPackageWithTax());
        TargetOrder.OrderDetail deliveryDetail = super.fillDeliveryGoods(order.getDeliveryWithTax(), order.getDiscountList());
        if (deliveryDetail != null) {
            targetDetails.add(deliveryDetail);
        }
        if (order.getAmountWithTax().compareTo(order.getDiscountWithTax()) < 0) {
            return new Tuple2((Object)"\u6298\u6263\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u91d1\u989d", null);
        }
        if (order.getActualAmount() != null) {
            totalAmountWithTax = targetDetails.stream().map(detail -> detail.getAmountWithTax().subtract(detail.getDiscountWithTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (order.getActualAmount().compareTo(totalAmountWithTax) != 0) {
                return new Tuple2((Object)"\u660e\u7ec6\u7d2f\u8ba1\u91d1\u989d\u4e0d\u7b49\u4e3b\u4fe1\u606f\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u5355\u636e", null);
            }
        }
        targetOrder.setDetailList(targetDetails);
        totalAmountWithTax = targetDetails.stream().map(detail -> detail.getAmountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountAmountWithTax = targetDetails.stream().map(detail -> detail.getDiscountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        targetOrder.setAmountWithTax(totalAmountWithTax);
        targetOrder.setDiscountWithTax(discountAmountWithTax);
        return new Tuple2((Object)"", (Object)targetOrder);
    }

    private Tuple2<String, TargetOrder> convertWithCoupon(SourceOrder order) {
        BigDecimal totalAmountWithTax;
        BigDecimal bigDecimal;
        TargetOrder targetOrder = new TargetOrder();
        targetOrder.setId(order.getId());
        targetOrder.setSource(order.getSource());
        targetOrder.setOrderNo(order.getOrderNo());
        targetOrder.setBrand(order.getBrand());
        targetOrder.setAmountWithTax(order.getAmountWithTax());
        Map<String, SourceOrder.Discount> discountMap = order.getDiscountList().stream().collect(Collectors.toMap(SourceOrder.Discount::getDiscountId, v -> v, (a, b) -> a));
        HashMap<String, ArrayList> minimumMap = new HashMap<String, ArrayList>();
        ArrayList targetDetails = Lists.newArrayList();
        SourceOrder.OrderDetail packageDetail = super.fillPackageFee(order.getPackageWithTax());
        if (packageDetail != null) {
            List giftCardDiscountList = order.getDiscountList().stream().filter(v -> StringUtils.equals((CharSequence)v.getDiscountType(), (CharSequence)String.valueOf(CouponTypeEnum.GIFT_CARD.getCode())) && StringUtils.equals((CharSequence)v.getSalesSource(), (CharSequence)SalesSourceEnum.HEAD.getCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(giftCardDiscountList)) {
                packageDetail.setDiscountIds(giftCardDiscountList.stream().map(v -> v.getDiscountId()).collect(Collectors.toList()));
            }
            order.getDetailList().add(packageDetail);
        }
        for (int i2 = 0; i2 < order.getDetailList().size(); ++i2) {
            SourceOrder.OrderDetail orderDetail = order.getDetailList().get(i2);
            TargetOrder.OrderDetail orderDetail2 = new TargetOrder.OrderDetail();
            orderDetail2.setAmountWithTax(orderDetail.getAmountWithTax());
            orderDetail2.setQuantity(orderDetail.getQuantity());
            orderDetail2.setUnitPrice(orderDetail.getUnitPrice());
            orderDetail2.setItemName(orderDetail.getItemName());
            orderDetail2.setItemNo(orderDetail.getItemNo());
            orderDetail2.setIndex(orderDetail.getIndex());
            if (StringUtils.isEmpty((CharSequence)orderDetail.getIndex())) {
                orderDetail2.setIndex(String.valueOf(i2));
            }
            orderDetail2.setUnit(orderDetail.getUnit());
            orderDetail2.setItemSpec(orderDetail.getItemSpec());
            orderDetail2.setItemCode(orderDetail.getItemCode());
            orderDetail2.setTaxConvertCode(orderDetail.getTaxConvertCode());
            orderDetail2.setDiscountWithTax(BigDecimal.ZERO);
            if (CollectionUtils.isNotEmpty(orderDetail.getDiscountIds())) {
                for (String discountId : orderDetail.getDiscountIds()) {
                    SourceOrder.Discount discount = discountMap.get(discountId);
                    if (discount == null) {
                        return new Tuple2((Object)(discountId + ":\u65e0\u6cd5\u5339\u914d\u5230\u5bf9\u5e94\u7684\u4f18\u60e0\u5238"), null);
                    }
                    if (discount.getReceivedWithTax() != null && discount.getReceivedWithTax().compareTo(BigDecimal.ZERO) > 0) {
                        if (StringUtils.equals((CharSequence)discount.getSalesSource(), (CharSequence)SalesSourceEnum.HEAD.getCode())) {
                            if (discount.getAmountWithTax().compareTo(orderDetail2.getAmountWithTax()) > 0) {
                                discount.setAmountWithTax(discount.getAmountWithTax().subtract(orderDetail2.getAmountWithTax()));
                                orderDetail2.setAmountWithTax(BigDecimal.ZERO);
                            } else {
                                orderDetail2.setAmountWithTax(orderDetail2.getAmountWithTax().subtract(discount.getAmountWithTax()));
                            }
                            orderDetail2.setUnitPrice(orderDetail2.getAmountWithTax().divide(orderDetail2.getQuantity(), 2, 4));
                            continue;
                        }
                        if (minimumMap.get(discountId) == null) {
                            minimumMap.put(discountId, Lists.newArrayList((Object[])new TargetOrder.OrderDetail[]{orderDetail2}));
                            continue;
                        }
                        ((List)minimumMap.get(discountId)).add(orderDetail2);
                        continue;
                    }
                    orderDetail2.setDiscountWithTax(orderDetail2.getDiscountWithTax().add(discount.getAmountWithTax()));
                }
            }
            if (orderDetail2.getAmountWithTax().compareTo(BigDecimal.ZERO) == 0) continue;
            targetDetails.add(orderDetail2);
        }
        Map<String, TargetOrder.OrderDetail> targetDetailMap = targetDetails.stream().collect(Collectors.toMap(TargetOrder.OrderDetail::getIndex, v -> v, (a, b) -> a));
        for (Map.Entry entry : minimumMap.entrySet()) {
            BigDecimal totalDiscountWithTax2;
            SourceOrder.Discount discount = discountMap.get(entry.getKey());
            if (discount == null) {
                return new Tuple2((Object)((String)entry.getKey() + ":\u65e0\u6cd5\u5339\u914d\u5230\u5bf9\u5e94\u7684\u4f18\u60e0\u5238"), null);
            }
            BigDecimal sumAmountWithTax = ((List)entry.getValue()).stream().map(detail -> detail.getAmountWithTax().subtract(detail.getDiscountWithTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal leftDiscountAmount = totalDiscountWithTax2 = discount.getAmountWithTax().subtract(discount.getReceivedWithTax());
            for (int i3 = 0; i3 < ((List)entry.getValue()).size(); ++i3) {
                TargetOrder.OrderDetail targetDetail;
                targetDetail.setDiscountWithTax((targetDetail = targetDetailMap.get(((TargetOrder.OrderDetail)((List)entry.getValue()).get(i3)).getIndex())).getDiscountWithTax() == null ? BigDecimal.ZERO : targetDetail.getDiscountWithTax());
                if (totalDiscountWithTax2 == null || totalDiscountWithTax2.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal proportion = targetDetail.getAmountWithTax().subtract(targetDetail.getDiscountWithTax()).divide(sumAmountWithTax, 6, 4);
                BigDecimal detailDiscountWithTax = proportion.multiply(totalDiscountWithTax2).setScale(2, 4);
                if (i3 == ((List)entry.getValue()).size() - 1) {
                    targetDetail.setDiscountWithTax(targetDetail.getDiscountWithTax().add(leftDiscountAmount));
                } else {
                    targetDetail.setDiscountWithTax(targetDetail.getDiscountWithTax().add(detailDiscountWithTax));
                }
                leftDiscountAmount = leftDiscountAmount.subtract(detailDiscountWithTax);
            }
        }
        BigDecimal sumAmountWithTax = targetDetails.stream().filter(i -> !StringUtils.equals((CharSequence)i.getIndex(), (CharSequence)"dbf")).map(detail -> detail.getAmountWithTax().subtract(detail.getDiscountWithTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal leftDiscountAmount = bigDecimal = order.getDiscountList().stream().filter(v -> (v.getReceivedWithTax() == null || v.getReceivedWithTax().compareTo(BigDecimal.ZERO) == 0) && !Lists.newArrayList((Object[])new String[]{String.valueOf(CouponTypeEnum.DELIVERY_FEE_DISCOUNT.getCode()), String.valueOf(CouponTypeEnum.PAID_MEMBERSHIP_DELIVERY_DISCOUNT.getCode())}).contains(v.getDiscountType())).map(SourceOrder.Discount::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        Map<Boolean, List<TargetOrder.OrderDetail>> feeAndItemMap = targetDetails.stream().collect(Collectors.groupingBy(v -> StringUtils.equals((CharSequence)v.getIndex(), (CharSequence)"dbf")));
        for (int i4 = 0; i4 < feeAndItemMap.get(false).size(); ++i4) {
            TargetOrder.OrderDetail targetDetail;
            targetDetail.setDiscountWithTax((targetDetail = (TargetOrder.OrderDetail)targetDetails.get(i4)).getDiscountWithTax() == null ? BigDecimal.ZERO : targetDetail.getDiscountWithTax());
            if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal proportion = targetDetail.getAmountWithTax().subtract(targetDetail.getDiscountWithTax()).divide(sumAmountWithTax, 6, 4);
                BigDecimal detailDiscountWithTax = proportion.multiply(bigDecimal).setScale(2, 4);
                if (i4 == feeAndItemMap.get(false).size() - 1) {
                    targetDetail.setDiscountWithTax(targetDetail.getDiscountWithTax().add(leftDiscountAmount));
                } else {
                    targetDetail.setDiscountWithTax(targetDetail.getDiscountWithTax().add(detailDiscountWithTax));
                }
                leftDiscountAmount = leftDiscountAmount.subtract(detailDiscountWithTax);
            }
            if (targetDetail.getAmountWithTax().compareTo(targetDetail.getDiscountWithTax()) >= 0) continue;
            return new Tuple2((Object)"\u660e\u7ec6\u6298\u6263\u4e0d\u80fd\u5927\u4e8e\u91d1\u989d", null);
        }
        TargetOrder.OrderDetail deliveryDetail = super.fillDeliveryGoods(order.getDeliveryWithTax(), order.getDiscountList());
        if (deliveryDetail != null) {
            targetDetails.add(deliveryDetail);
        }
        if (order.getActualAmount() != null) {
            totalAmountWithTax = targetDetails.stream().map(detail -> detail.getAmountWithTax().subtract(detail.getDiscountWithTax())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (order.getActualAmount().compareTo(totalAmountWithTax) != 0) {
                return new Tuple2((Object)"\u660e\u7ec6\u7d2f\u8ba1\u91d1\u989d\u4e0d\u7b49\u4e3b\u4fe1\u606f\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u5355\u636e", null);
            }
        }
        totalAmountWithTax = targetDetails.stream().map(detail -> detail.getAmountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountAmountWithTax = targetDetails.stream().map(detail -> detail.getDiscountWithTax()).reduce(BigDecimal.ZERO, BigDecimal::add);
        targetOrder.setAmountWithTax(totalAmountWithTax);
        targetOrder.setDiscountWithTax(discountAmountWithTax);
        targetOrder.setDetailList(targetDetails);
        return new Tuple2((Object)"", (Object)targetOrder);
    }
}

